// Session.h : Declaration of the CDbSession
#ifndef __CDbSession_H_
#define __CDbSession_H_

#include "resource.h"       // main symbols
#include "RS.h"


class CDbSessionTRSchemaRowset;
class CDbSessionColSchemaRowset;
class CDbSessionPTSchemaRowset;


/////////////////////////////////////////////////////////////////////////////
// CDbSession

class ATL_NO_VTABLE CDbSession : 
   public CComObjectRootEx<CComSingleThreadModel>,
   public IGetDataSourceImpl<CDbSession>,
   public IOpenRowsetImpl<CDbSession>,
   public ISessionPropertiesImpl<CDbSession>,
   public IObjectWithSiteSessionImpl<CDbSession>,
   public IDBSchemaRowsetImpl<CDbSession>,
   public IDBCreateCommandImpl<CDbSession, CDbCommand>
{
public:
   CDbSession()
   {
   }
   HRESULT FinalConstruct()
   {
      return FInit();
   }
   STDMETHOD(OpenRowset)(IUnknown *pUnk, DBID *pTID, DBID *pInID, REFIID riid,
                  ULONG cSets, DBPROPSET rgSets[], IUnknown **ppRowset)
   {
      CDbRowset* pRowset;
      return CreateRowset(pUnk, pTID, pInID, riid, cSets, rgSets, ppRowset, pRowset);
   }

BEGIN_PROPSET_MAP(CDbSession)
   BEGIN_PROPERTY_SET(DBPROPSET_SESSION)
      PROPERTY_INFO_ENTRY(SESS_AUTOCOMMITISOLEVELS)
   END_PROPERTY_SET(DBPROPSET_SESSION)
END_PROPSET_MAP()

BEGIN_COM_MAP(CDbSession)
   COM_INTERFACE_ENTRY(IGetDataSource)
   COM_INTERFACE_ENTRY(IOpenRowset)
   COM_INTERFACE_ENTRY(ISessionProperties)
   COM_INTERFACE_ENTRY(IObjectWithSite)
   COM_INTERFACE_ENTRY(IDBCreateCommand)
   COM_INTERFACE_ENTRY(IDBSchemaRowset)
END_COM_MAP()

BEGIN_SCHEMA_MAP(CDbSession)
   SCHEMA_ENTRY(DBSCHEMA_TABLES, CDbSessionTRSchemaRowset)
   SCHEMA_ENTRY(DBSCHEMA_COLUMNS, CDbSessionColSchemaRowset)
   SCHEMA_ENTRY(DBSCHEMA_PROVIDER_TYPES, CDbSessionPTSchemaRowset)
END_SCHEMA_MAP()
};


class CDbSessionTRSchemaRowset : 
   public CRowsetImpl< CDbSessionTRSchemaRowset, CTABLESRow, CDbSession >
{
public:
   HRESULT Execute(LONG* pcRowsAffected, ULONG, const VARIANT*)
   {
      // There is just one table: Items
      CTABLESRow trData;
      ::lstrcpyW(trData.m_szType, OLESTR("TABLE"));
      ::lstrcpyW(trData.m_szDesc, OLESTR("The Items"));
      ::lstrcpynW(trData.m_szTable, L"Items", SIZEOF_MEMBER(CTABLESRow, m_szTable));
      if( !m_rgRowData.Add(trData) ) return E_OUTOFMEMORY;
      *pcRowsAffected = 1;
      return S_OK;
   }
   DBSTATUS GetDBStatus(CSimpleRow*, ATLCOLUMNINFO* pInfo)
   {
      if( pInfo->iOrdinal==1 || pInfo->iOrdinal==2 ) return DBSTATUS_S_ISNULL;
      return DBSTATUS_S_OK;
   }
};


class CDbSessionColSchemaRowset : 
   public CRowsetImpl< CDbSessionColSchemaRowset, CCOLUMNSRow, CDbSession >
{
public:
   HRESULT Execute(LONG* pcRowsAffected, ULONG, const VARIANT*)
   {
      DBID dbid;
      memset(&dbid, 0, sizeof(DBID));
      dbid.uName.pwszName = L"Items";
      dbid.eKind = DBKIND_NAME;
      return InitFromRowset< _RowsetArrayType >(m_rgRowData, &dbid, NULL, m_spUnkSite, pcRowsAffected);
   }
   DBSTATUS GetDBStatus(CSimpleRow*, ATLCOLUMNINFO* pInfo)
   {
      switch(pInfo->iOrdinal)
      {
      case 1:
      case 2:
      case 19:
      case 20:
      case 22:
      case 23:
      case 25:
      case 26:
         return DBSTATUS_S_ISNULL;
      default:
         return DBSTATUS_S_OK;
      }
   }
};


class CDbSessionPTSchemaRowset : 
   public CRowsetImpl< CDbSessionPTSchemaRowset, CPROVIDER_TYPERow, CDbSession >
{
public:
   HRESULT Execute(LONG* pcRowsAffected, ULONG, const VARIANT*)
   {
      return S_OK;
   }
};


#endif //__CDbSession_H_
