// ServerOLEDB.cpp : Implementation of DLL Exports.

#include "stdafx.h"

#include "resource.h"
#include <initguid.h>

#include "Session.h"
#include "DS.h"


CComModule _Module;

DEFINE_GUID(CLSID_ServerDb, 0x3F74B0CC,0xD122,0x49E9, 0x9E,0xDC,0x81,0xFA,0xFA,0x51,0xA9,0x7D);


BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_ServerDb, CDbSource)
END_OBJECT_MAP()


/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
   if (dwReason == DLL_PROCESS_ATTACH) {
      _Module.Init(ObjectMap, hInstance);
      ::DisableThreadLibraryCalls(hInstance);
   }
   else if (dwReason == DLL_PROCESS_DETACH) {
      _Module.Term();
   }
   return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
   return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
   return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
   // Registers object, typelib and all interfaces in typelib
   return _Module.RegisterServer(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
   return _Module.UnregisterServer(FALSE);
}

