VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "NamedPipe"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Function CreateFile Lib "kernel32" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, ByVal lpSecurityAttributes As Long, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Private Declare Function ReadFile Lib "kernel32" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToRead As Long, lpNumberOfBytesRead As Long, ByVal lpOverlapped As Long) As Long
Private Declare Function WriteFile Lib "kernel32" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToWrite As Long, lpNumberOfBytesWritten As Long, ByVal lpOverlapped As Long) As Long
Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Private Declare Function GetLastError Lib "kernel32" () As Long
Private Const FILE_ATTRIBUTE_NORMAL As Long = &H80
Private Const OPEN_EXISTING As Long = 3
Private Const GENERIC_READ As Long = &H80000000
Private Const GENERIC_WRITE As Long = &H40000000

Implements IProtocol

Private m_sServer As String
Private m_sName As String
Private m_iTimeout As Integer
Private m_hPipe As Long

Public Sub SetName(ByVal Name As String)
   m_sName = Name
End Sub

Public Sub SetTimeout(ByVal Timeout As Integer)
   m_iTimeout = Timeout
End Sub

Private Sub IProtocol_Connect()
   Dim sPipe As String
   Dim iFlags As Long
   sPipe = "\\" + m_sServer + "\pipe\" + m_sName
   iFlags = GENERIC_READ Or GENERIC_WRITE
   m_hPipe = CreateFile(sPipe, iFlags, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)
   If m_hPipe = -1 Then Err.Raise vbClassError + GetLastError(), "Unable to connect to named pipe."
End Sub

Private Sub IProtocol_Disconnect()
   Call CloseHandle(m_hPipe)
End Sub

Private Function IProtocol_GetItem(ByVal Item As String) As String
   Dim ret As Long
   Dim x() As Byte
   Dim s As String
   Dim dwWritten As Long
   s = "GET " + Item + vbLf
   x = StrConv(s, vbProperCase)
   ret = WriteFile(m_hPipe, x(0), LenB(s), dwWritten, 0)
   If ret = 0 Then Err.Raise vbClassError + GetLastError(), "Failed to write to pipe."
   Dim y() As Byte
   ReDim y(2000) As Byte
   Dim dwRead As Long
   ret = ReadFile(m_hPipe, y(0), UBound(y), dwRead, 0)
   If ret = 0 Then Err.Raise vbClassError + GetLastError(), "Failed to read from pipe."
   ReDim Preserve y(dwRead) As Byte
   s = StrConv(y, vbProperCase)
   s = Left(s, Len(s) - 1) ' remove newline
   IProtocol_GetItem = s
End Function

Private Function IProtocol_SetItem(ByVal Item As String, ByVal Value As String) As String
   Dim ret As Long
   Dim x() As Byte
   Dim s As String
   Dim dwWritten As Long
   s = "SET " + Item + " " + Value + vbLf
   x = StrConv(s, vbProperCase)
   ret = WriteFile(m_hPipe, x(0), LenB(s), dwWritten, 0)
   If ret = 0 Then Err.Raise vbClassError + GetLastError(), "Failed to write to pipe."
   Dim y() As Byte
   ReDim y(2000) As Byte
   Dim dwRead As Long
   ret = ReadFile(m_hPipe, y(0), UBound(y), dwRead, 0)
   If ret = 0 Then Err.Raise vbClassError + GetLastError(), "Failed to read from pipe."
   ReDim Preserve y(dwRead) As Byte
   s = StrConv(y, vbProperCase)
   s = Left(s, Len(s) - 1) ' remove newline
   IProtocol_SetItem = s
End Function

Private Sub IProtocol_SetServer(ByVal Server As String)
   m_sServer = Server
End Sub
