// stdafx.h : include file for standard system include files,
//      or project specific include files that are used frequently,
//      but are changed infrequently

#if !defined(AFX_STDAFX_H__B9F80E14_5D35_44CE_877E_0CBDED4A3080__INCLUDED_)
#define AFX_STDAFX_H__B9F80E14_5D35_44CE_877E_0CBDED4A3080__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define STRICT
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif
#define _ATL_APARTMENT_THREADED

#include <atlbase.h>
#include "DataStorage.h"

class CServiceModule : public CComModule
{
public:
   HRESULT RegisterServer(BOOL bRegTypeLib, BOOL bService);
   HRESULT UnregisterServer();
   void Init(_ATL_OBJMAP_ENTRY* p, HINSTANCE h, UINT nServiceNameID, const GUID* plibid = NULL);
   void Start();
   void ServiceMain(DWORD dwArgc, LPTSTR* lpszArgv);
   void Handler(DWORD dwOpcode);
   void Run();
   BOOL IsInstalled();
   BOOL Install();
   BOOL Uninstall();
   LONG Unlock();
   void LogEvent(LPCTSTR pszFormat, ...);
   void SetServiceStatus(DWORD dwState);
   void SetupAsLocalServer();
   void Execute();

//Implementation
private:
   static void WINAPI _ServiceMain(DWORD dwArgc, LPTSTR* lpszArgv);
   static void WINAPI _ServiceHandler(DWORD dwOpcode);
   static BOOL WINAPI _ConsoleHandler(DWORD dwOpcode);

// Data members
public:
   CDataStorage m_data;
   TCHAR m_szServiceName[256];
   SERVICE_STATUS_HANDLE m_hServiceStatus;
   SERVICE_STATUS m_status;
   DWORD m_dwThreadID;
   BOOL m_bService;
};
extern CServiceModule _Module;

#include <atlcom.h>

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_STDAFX_H__B9F80E14_5D35_44CE_877E_0CBDED4A3080__INCLUDED)
