#if !defined(AFX_NAMEDPIPESERVER_H__20010923_8779_8315_AB7D_0080AD509054__INCLUDED_)
#define AFX_NAMEDPIPESERVER_H__20010923_8779_8315_AB7D_0080AD509054__INCLUDED_

#pragma once


class CNamedPipeServer : public CThreadImpl<CNamedPipeServer>
{
public:
   enum { MAX_PIPES = 5 };
   enum { PIPE_TIMEOUT = 0 };
   enum { BUFFERSIZE = 2048 };

   typedef struct 
   {
      CNamedPipeServer *pT;
      HANDLE hPipe;
   } THREADARGS;

   volatile LONG m_nThreads;

   CNamedPipeServer() : m_nThreads(0L)
   {
   }

   void Stop()
   {
      Abort();
      // Need to send something to the pipe so the thread gets
      // out of a possible idle state
      LPCTSTR lpszPipename = _T("\\\\.\\pipe\\viksoe\\npipe"); 
      CNamedPipe np;
      if( np.Open(lpszPipename) ) {
         np.Close();
      }
      // Then we need to wait on all worker threads
      while( m_nThreads > 0 ) ::Sleep(200L);
      // Stop dispatcher thread
      CThreadImpl<CNamedPipeServer>::Stop();
   }

   DWORD Run()
   {
      LPCTSTR lpszPipename = _T("\\\\.\\pipe\\viksoe\\npipe"); 
      
      while( !IsAborted() ) {

         // Create named pipe
         HANDLE hPipe = ::CreateNamedPipe( 
             lpszPipename,             // pipe name 
             PIPE_ACCESS_DUPLEX |      // read/write access 
             FILE_FLAG_OVERLAPPED,     // overlapped support
             PIPE_TYPE_BYTE |          // message type pipe 
             PIPE_READMODE_BYTE |      // message-read mode 
             PIPE_WAIT,                // blocking mode 
             PIPE_UNLIMITED_INSTANCES, // max. instances  
             BUFFERSIZE,               // output buffer size 
             BUFFERSIZE,               // input buffer size 
             PIPE_TIMEOUT,             // client time-out 
             NULL);                    // no security attribute 
         if( hPipe == INVALID_HANDLE_VALUE ) {
            lprintf(_T("Failed to create Named Pipe!\n"));
            continue;
         }
 
         // Wait for the client to connect; if it succeeds, 
         // the function returns a nonzero value. If the function returns 
         // zero, GetLastError() may return ERROR_PIPE_CONNECTED. 
         BOOL fConnected = ::ConnectNamedPipe(hPipe, NULL) ? TRUE : (::GetLastError()==ERROR_PIPE_CONNECTED);
         if( IsAborted() ) {
            // The service is about to stop
            ::CloseHandle(hPipe); 
            break;
         }
         if( !fConnected ) {
            // The client could not connect, so close the pipe. 
            ::CloseHandle(hPipe); 
            continue;
         }

         // Prepare thread arguments
         THREADARGS *pArgs = new THREADARGS;
         pArgs->pT = this;
         pArgs->hPipe = hPipe;
         // Create a thread for this client. 
         DWORD dwThreadId;
         HANDLE hThread = ::CreateThread( 
            NULL,              // no security attribute 
            0,                 // default stack size 
            (LPTHREAD_START_ROUTINE)PipeProc, 
            pArgs,             // thread parameter 
            0,                 // not suspended 
            &dwThreadId);      // returns thread ID 
         if( hThread==NULL ) {
            lprintf(_T("Unable to create Named Pipe thread.\n"));
            continue;
         }
         ::CloseHandle(hThread); 
      }
      return 0;
   }

   static DWORD WINAPI PipeProc(LPVOID lParam)
   {
      THREADARGS *pArgs = (THREADARGS *)lParam;
      _ASSERTE(pArgs);
      CNamedPipeServer *pThis = pArgs->pT;
      HANDLE hPipe = pArgs->hPipe;
      delete pArgs;

      ::InterlockedIncrement(&pThis->m_nThreads);
      lprintf(_T("Creating NamedPipe client.\n"));

      CServerProtocol<CNamedPipe> sp(&pThis->m_bStopped);
      sp.m_tp.Attach(hPipe);
      sp.ServeClient();

      lprintf(_T("Closing NamedPipe client.\n"));
      ::InterlockedDecrement(&pThis->m_nThreads);

      return 0;
   }

};


#endif // !defined(AFX_NAMEDPIPESERVER_H__20010923_8779_8315_AB7D_0080AD509054__INCLUDED_)

