#if !defined(AFX_MAILSLOTSERVER_H__20010922_96A0_6A88_566D_0080AD509054__INCLUDED_)
#define AFX_MAILSLOTSERVER_H__20010922_96A0_6A88_566D_0080AD509054__INCLUDED_

#pragma once

//
// Commands:
//   Name: List available servers
//     Command:  "LIST: <computername>"
//     Response: "ID: <computername>"
//   Name: Kill server
//     Command:  "QUIT: ."
//     Response: none
//   No Operation (dummy)
//     Command:  "NOP: ."
//     Response: none
//

class CMailSlotServer : public CThreadImpl<CMailSlotServer>
{
public:
   void Stop()
   {
      Abort();
      // Need to send something to the mailslot so the thread gets
      // out of a possible idle state
      CMailSlot ms;
      if( ms.Open(_T("\\\\.\\mailslot\\viksoe\\server")) ) {
         WCHAR wszBuffer[] = L"NOP: .";
         ms.Write(wszBuffer, sizeof(wszBuffer));
         ms.Close();
      }
      CThreadImpl<CMailSlotServer>::Stop();
   }

   DWORD Run()
   {
      USES_CONVERSION;

      CMailSlot ms;
      if( ms.Create(_T("\\\\.\\mailslot\\viksoe\\server"))==FALSE ) {
         lprintf(_T("Failed to create MailSlot!\n"));
         return 0;
      }
      WCHAR buffer[200];
      while( ms.Read(buffer, sizeof(buffer)) ) {
         lprintf(_T("Received MailSlot request: \"%ls\"\n"), buffer);
         if( IsAborted() ) break;

         LPWSTR pwstr = wcschr(buffer, L':');
         if( pwstr==NULL ) continue;
         TCHAR szCmd[10] = { 0 };
         TCHAR szRemoteComputer[128];
         _tcsncpy( szCmd, W2CT(buffer), pwstr-buffer);
         _tcscpy( szRemoteComputer, W2CT(pwstr+2) );

         TCHAR szMsg[200] = { 0 };
         if( _tcscmp(szCmd, _T("LIST"))==0 ) {
            TCHAR szComputerName[80];
            DWORD dwLen = sizeof(szComputerName)/sizeof(TCHAR);
            ::GetComputerName(szComputerName, &dwLen);
            ::wsprintf(szMsg, _T("ID: %s"), szComputerName);
         }
         else if( _tcscmp(szCmd, _T("QUIT"))==0 ) {
            ::PostThreadMessage(_Module.m_dwThreadID, WM_QUIT, 0, 0);
            continue;
         }
         else {
            // Don't react on messages that we don't understand!
            continue;
         }
         // Send response to remote mailslot
         TCHAR szRemoteSlot[200];
         ::wsprintf(szRemoteSlot, _T("\\\\%s\\mailslot\\viksoe\\client"), szRemoteComputer);
         CMailSlot remote;
         if( remote.Open(szRemoteSlot) ) {
            LPCWSTR pwstrBuffer = T2CW(szMsg);
            remote.Write(pwstrBuffer, (wcslen(pwstrBuffer)+1)*sizeof(WCHAR));
            remote.Close();
         }
      }
      ms.Close();
      return 0;
   }
};


#endif // !defined(AFX_MAILSLOTSERVER_H__20010922_96A0_6A88_566D_0080AD509054__INCLUDED_)

