// SERVERPROXY.CPP - Implementation file for your Internet Server
//    Server1 HTTP Proxy

#include "stdafx.h"
#include "ServerProxy.h"

#include <atlbase.h>
#include "NetApiWrappers.h"


///////////////////////////////////////////////////////////////////////
// Command-parsing map

BEGIN_PARSE_MAP(CServerProxyExtension, CHttpServer)
   ON_PARSE_COMMAND(Get, CServerProxyExtension, ITS_PSTR)
   ON_PARSE_COMMAND_PARAMS("Item")
   ON_PARSE_COMMAND(Set, CServerProxyExtension, ITS_PSTR ITS_PSTR)
   ON_PARSE_COMMAND_PARAMS("Item Value")
   DEFAULT_PARSE_COMMAND(Default, CServerProxyExtension)
END_PARSE_MAP(CServerProxyExtension)


///////////////////////////////////////////////////////////////////////
// The one and only CServerProxyExtension object

CServerProxyExtension theExtension;

class CSafeContent
{
public:
   CHttpServerContext *m_pCtxt;
   CServerProxyExtension *m_pExt;
   
   CSafeContent(CServerProxyExtension *pExt, CHttpServerContext *pCtxt)
   {
      m_pExt = pExt;
      m_pCtxt = pCtxt;
      m_pExt->StartContent(m_pCtxt);
      m_pExt->WriteTitle(m_pCtxt);
   }
   ~CSafeContent()
   {
      m_pExt->EndContent(m_pCtxt);
   }
};


///////////////////////////////////////////////////////////////////////
// CServerProxyExtension implementation

CServerProxyExtension::CServerProxyExtension()
{
   ATLTRACE(_T("CServerProxyExtension::CServerProxyExtension()\n"));
   m_iPort = 0;
   _tcscpy( m_szRemoteName, _T("") );

   CRegKey reg;
   if( reg.Open(HKEY_LOCAL_MACHINE, _T("SOFTWARE\\Viksoe\\ServerProxy"), KEY_READ)==ERROR_SUCCESS ) {
      DWORD dwValue;
      reg.QueryValue(dwValue, _T("Port"));
      m_iPort = (u_short)dwValue;
      DWORD dwCount = sizeof(m_szRemoteName)/sizeof(TCHAR);
      reg.QueryValue(m_szRemoteName, _T("Server"), &dwCount);
      reg.Close();
   }
}

CServerProxyExtension::~CServerProxyExtension()
{
}

BOOL CServerProxyExtension::GetExtensionVersion(HSE_VERSION_INFO* pVer)
{
   // Call default implementation for initialization
   CHttpServer::GetExtensionVersion(pVer);

   // Load description string
   TCHAR sz[HSE_MAX_EXT_DLL_NAME_LEN+1];
   ISAPIVERIFY(::LoadString(AfxGetResourceHandle(), IDS_SERVER, sz, HSE_MAX_EXT_DLL_NAME_LEN));
   _tcscpy(pVer->lpszExtensionDesc, sz);
   return TRUE;
}

BOOL CServerProxyExtension::TerminateExtension(DWORD dwFlags)
{
   // Extension is being terminated
   return TRUE;
}

void CServerProxyExtension::StartContent(CHttpServerContext* pCtxt)
{
   // Remember to say that the content always expires!
   AddHeader(pCtxt, _T("cache-control:no-cache\r\n"));
   AddHeader(pCtxt, _T("pragma: no-cache\r\n"));
   AddHeader(pCtxt, _T("expires:0\r\n"));
   CHttpServer::StartContent(pCtxt);
}


///////////////////////////////////////////////////////////////////////
// CServerProxyExtension command handlers

void CServerProxyExtension::Get(CHttpServerContext* pCtxt, LPCSTR pstrItem)
{
   ATLTRACE(_T("CServerProxyExtension::Get()\n"));
   USES_CONVERSION;
   CSafeContent content(this, pCtxt);

   if( m_iPort==0 || _tcslen(m_szRemoteName)==0 ) {
      *pCtxt << _T("1 Remote Server Name or TCP/IP Port not found in registry.\n");
      return;
   }
   CSocket ip;
   if( ip.Open(m_iPort, m_szRemoteName)==FALSE ) {
      *pCtxt << _T("1 Unable to connect to server.\n");
      return;
   }
   WCHAR wszBuffer[300];
   wcscpy( wszBuffer, L"GET ");
   wcscat( wszBuffer, A2CW(pstrItem) );
   wcscat( wszBuffer, L"\n" );
   if( ip.Write(wszBuffer, wcslen(wszBuffer)*sizeof(OLECHAR))==FALSE ) {
      *pCtxt << _T("1 Unable to write stuff to server.\n");
      return;
   }
   DWORD dwRead;
   if( ip.Read(wszBuffer, sizeof(wszBuffer)-2, &dwRead)==FALSE ) {
      *pCtxt << _T("1 Error while communicating with server.\n");
      return;
   }
   wszBuffer[dwRead/sizeof(WCHAR)] = L'\0';
   *pCtxt << W2CT(wszBuffer);
   ip.Close();
}

void CServerProxyExtension::Set(CHttpServerContext* pCtxt, LPCSTR pstrItem, LPCSTR pstrValue)
{
   ATLTRACE(_T("CServerProxyExtension::Set()\n"));
   USES_CONVERSION;
   CSafeContent content(this, pCtxt);

   if( m_iPort==0 || _tcslen(m_szRemoteName)==0 ) {
      *pCtxt << _T("1 Remote Server Name or TCP/IP Port not found in registry.\n");
      return;
   }
   CSocket ip;
   if( ip.Open(m_iPort, m_szRemoteName)==FALSE ) {
      *pCtxt << _T("1 Unable to connect to server.\n");
      return;
   }
   WCHAR wszBuffer[300];
   wcscpy( wszBuffer, L"SET ");
   wcscat( wszBuffer, A2CW(pstrItem) );
   wcscat( wszBuffer, L" " );
   wcscat( wszBuffer, A2CW(pstrValue) );
   wcscat( wszBuffer, L"\n" );
   if( ip.Write(wszBuffer, wcslen(wszBuffer)*sizeof(OLECHAR))==FALSE ) {
      *pCtxt << _T("1 Unable to write stuff to server.\n");
      return;
   }
   DWORD dwRead;
   if( ip.Read(wszBuffer, sizeof(wszBuffer)-2, &dwRead)==FALSE ) {
      *pCtxt << _T("1 Error while communicating with server.\n");
      return;
   }
   wszBuffer[dwRead/sizeof(WCHAR)] = L'\0';
   *pCtxt << W2CT(wszBuffer);
   ip.Close();
}

void CServerProxyExtension::Default(CHttpServerContext* pCtxt)
{
   CSafeContent content(this, pCtxt);
   *pCtxt << _T("The Server1 HTTP Proxy needs arguments.\r\n");
}

// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CServerProxyExtension, CHttpServer)
   //{{AFX_MSG_MAP(CServerProxyExtension)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif   // 0



///////////////////////////////////////////////////////////////////////
// Initialize DLL
//

static HINSTANCE g_hInstance;

HINSTANCE AFXISAPI AfxGetResourceHandle()
{
   return g_hInstance;
}

BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ulReason, LPVOID lpReserved)
{
   if( ulReason==DLL_PROCESS_ATTACH ) {
      g_hInstance = hInst;
   }
   return TRUE;
}

