// RS.h : Declaration of the CDbRowset
#ifndef __CDbRowset_H_
#define __CDbRowset_H_

#include "resource.h"       // main symbols
#include "NetApiWrappers.h"
#include "SQLParser.h"

class CDbRowset;

class CItem
{
public:
   CItem()
   {
      m_szName[0] = '\0';
      m_szValue[0] = '\0';
   }
   CItem(CHAR cName, LPCTSTR pstrValue)
   {
      m_szName[0] = cName;
      m_szName[1] = _T('\0');
      _tcscpy( m_szValue, pstrValue );
   }

   TCHAR m_szName[2];
   TCHAR m_szValue[200];

BEGIN_PROVIDER_COLUMN_MAP(CItem)
   PROVIDER_COLUMN_ENTRY("Name", 1, m_szName)
   PROVIDER_COLUMN_ENTRY("Value", 2, m_szValue)
END_PROVIDER_COLUMN_MAP()
};


// CDbCommand
class ATL_NO_VTABLE CDbCommand : 
   public CComObjectRootEx<CComSingleThreadModel>,
   public IAccessorImpl<CDbCommand>,
   public ICommandTextImpl<CDbCommand>,
   public ICommandPropertiesImpl<CDbCommand>,
   public IObjectWithSiteImpl<CDbCommand>,
   public IConvertTypeImpl<CDbCommand>,
   public IColumnsInfoImpl<CDbCommand>
{
public:

BEGIN_COM_MAP(CDbCommand)
   COM_INTERFACE_ENTRY(ICommand)
   COM_INTERFACE_ENTRY(IObjectWithSite)
   COM_INTERFACE_ENTRY(IAccessor)
   COM_INTERFACE_ENTRY(ICommandProperties)
   COM_INTERFACE_ENTRY2(ICommandText, ICommand)
   COM_INTERFACE_ENTRY(IColumnsInfo)
   COM_INTERFACE_ENTRY(IConvertType)
END_COM_MAP()

// ICommand
public:
   HRESULT FinalConstruct()
   {
      HRESULT hr = CConvertHelper::FinalConstruct();
      if (FAILED (hr)) return hr;
      hr = IAccessorImpl<CDbCommand>::FinalConstruct();
      if (FAILED(hr)) return hr;
      return CUtlProps<CDbCommand>::FInit();
   }
   void FinalRelease()
   {
      IAccessorImpl<CDbCommand>::FinalRelease();
   }
   static ATLCOLUMNINFO* GetColumnInfo(CDbCommand* pv, ULONG* pcInfo)
   {
      return CItem::GetColumnInfo(pv,pcInfo);
   }
   HRESULT WINAPI Execute(IUnknown * pUnkOuter, REFIID riid, DBPARAMS * pParams, 
                            LONG * pcRowsAffected, IUnknown ** ppRowset)
   {
      CDbRowset* pRowset;
      return CreateRowset(pUnkOuter, riid, pParams, pcRowsAffected, ppRowset, pRowset);
   }

BEGIN_PROPSET_MAP(CDbCommand)
   BEGIN_PROPERTY_SET(DBPROPSET_ROWSET)
      PROPERTY_INFO_ENTRY(IAccessor)
      PROPERTY_INFO_ENTRY(IColumnsInfo)
      PROPERTY_INFO_ENTRY(IConvertType)
      PROPERTY_INFO_ENTRY(IRowset)
      PROPERTY_INFO_ENTRY(IRowsetIdentity)
      PROPERTY_INFO_ENTRY(IRowsetInfo)
      PROPERTY_INFO_ENTRY(IRowsetLocate)
      PROPERTY_INFO_ENTRY(BOOKMARKS)
      PROPERTY_INFO_ENTRY(BOOKMARKSKIPPED)
      PROPERTY_INFO_ENTRY(BOOKMARKTYPE)
      PROPERTY_INFO_ENTRY(CANFETCHBACKWARDS)
      PROPERTY_INFO_ENTRY(CANHOLDROWS)
      PROPERTY_INFO_ENTRY(CANSCROLLBACKWARDS)
      PROPERTY_INFO_ENTRY(LITERALBOOKMARKS)
      PROPERTY_INFO_ENTRY(ORDEREDBOOKMARKS)
   END_PROPERTY_SET(DBPROPSET_ROWSET)
END_PROPSET_MAP()

};


template <class T>
class CRunTimeDelete
{
public:
   static void Free(T* pData)
   {
      delete pData;
   }
};


class CDbRowset : public CRowsetImpl< CDbRowset, CItem, CDbCommand >
{
public:
   HRESULT Execute(DBPARAMS * pParams, LONG* pcRowsAffected)
   {
      USES_CONVERSION;
      if( pcRowsAffected!=NULL ) *pcRowsAffected = 0;
      HRESULT Hr;

      // Get the DataSource object so we can read its properties
      CComQIPtr<IObjectWithSite> spSite = m_spUnkSite;
      if( spSite==NULL ) return E_NOINTERFACE;
      CComQIPtr<IGetDataSource> spGetDS;
      if( FAILED( spSite->GetSite(IID_IGetDataSource, (LPVOID *)&spGetDS) ) ) return E_NOINTERFACE;
      CComQIPtr<IDBProperties> spDataSource;
      if( FAILED( spGetDS->GetDataSource(IID_IDBProperties, (LPUNKNOWN *)&spDataSource) ) ) return E_NOINTERFACE;

      // Get the value of the DBPROP_INIT_DATASOURCE property
      DBPROPIDSET PropIDSet[1];
      ULONG cPropertySets;
      DBPROPSET* pPropSet;
      DBPROPID PropId[1];
      PropId[0] = DBPROP_INIT_DATASOURCE;
      PropIDSet[0].guidPropertySet = DBPROPSET_DBINIT;
      PropIDSet[0].rgPropertyIDs = PropId;
      PropIDSet[0].cPropertyIDs = sizeof(PropId)/sizeof(DBPROPID);
      Hr = spDataSource->GetProperties(1, PropIDSet, &cPropertySets, &pPropSet );
      if( FAILED(Hr) ) return E_FAIL;

      TCHAR szPipeName[100];
      ::wsprintf(szPipeName, _T("\\\\%ls\\pipe\\viksoe\\npipe"), V_BSTR(&pPropSet[0].rgProperties->vValue) );

      ::CoTaskMemFree(pPropSet->rgProperties);
      ::CoTaskMemFree(pPropSet);

      CLexer lexer;
      PCMDOP pTree = NULL;
      try
      {
         pTree = lexer.Lex(OLE2CT(m_strCommandText));
         if( pTree==NULL ) throw ERR_UNEXPECTED;
      }
      catch( ... ) 
      {
         return DB_E_ERRORSINCOMMAND;
      }
      CAutoMemRelease< CMDOP, CRunTimeDelete<CMDOP> > autofree(pTree);

      CEvaluator eval;
      EVALPROP prop[2];
      _tcscpy( prop[0].szName, _T("Name") );
      _tcscpy( prop[1].szName, _T("Value") );

      switch( pTree->type ) {
      case OP_SELECT:
         {
            if( _tcsicmp( pTree->left->value, _T("*"))!=0 ) return DB_E_BADCOLUMNID;
            if( _tcsicmp( pTree->right->left->value, _T("items"))!=0 ) return DB_E_NOTABLE;

            CNamedPipe np;
            if( np.Open(szPipeName)==FALSE ) return DB_E_CANNOTCONNECT;
            
            LONG cItems = 0;

            for( WCHAR c=L'A'; c<=L'Z'; c++ ) {
               WCHAR szItem[2] = { 0 };
               szItem[0] = c;
               WCHAR wszBuffer[300];
               wcscpy( wszBuffer, L"GET ");
               wcscat( wszBuffer, szItem );
               wcscat( wszBuffer, L"\n" );
               if( np.Write(wszBuffer, wcslen(wszBuffer)*sizeof(OLECHAR))==FALSE ) return DB_E_CANCELED;
               DWORD dwRead;
               if( np.Read(wszBuffer, sizeof(wszBuffer), &dwRead)==FALSE ) return DB_E_CANCELED;
               wszBuffer[(dwRead/sizeof(WCHAR))-1] = L'\0'; // terminate and remove newline

               // Found it? Error code 0 indicates so...
               if( wszBuffer[0] == L'0' ) {
                  // Match the entry with WHERE clause
                  try 
                  {
                     CItem item( TCHAR(c), W2CT(wszBuffer + 2) );
                     _tcscpy( prop[0].szValue, item.m_szName );
                     _tcscpy( prop[1].szValue, item.m_szValue );
                     BOOL ok = eval.Evaluate(pTree->right->right, prop, sizeof(prop)/sizeof(EVALPROP));
                     if( ok ) {
                        if( !m_rgRowData.Add(item) ) return E_OUTOFMEMORY;
                        cItems++;
                     }
                  }
                  catch( ... ) 
                  {
                     return DB_E_ERRORSINCOMMAND;
                  }
               }
            }
            np.Close();
            if( pcRowsAffected!=NULL ) *pcRowsAffected = cItems;
            return S_OK;
         }
      case OP_UPDATE:
         {
            if( pcRowsAffected!=NULL ) *pcRowsAffected = 0;
            if( _tcsicmp( pTree->left->value, _T("items"))!=0 ) return DB_E_NOTABLE;
            if( _tcsicmp( pTree->right->left->left->value, _T("value"))!=0 ) return DB_E_BADCOLUMNID;

            CNamedPipe np;
            if( np.Open(szPipeName)==FALSE ) return DB_E_CANNOTCONNECT;

            LONG cItems = 0;

            for( WCHAR c=L'A'; c<=L'Z'; c++ ) {
               WCHAR szItem[2] = { 0 };
               szItem[0] = c;
               WCHAR wszBuffer[300];
               wcscpy( wszBuffer, L"GET ");
               wcscat( wszBuffer, szItem );
               wcscat( wszBuffer, L"\n" );
               if( np.Write(wszBuffer, wcslen(wszBuffer)*sizeof(OLECHAR))==FALSE ) return DB_E_CANCELED;
               DWORD dwRead;
               if( np.Read(wszBuffer, sizeof(wszBuffer), &dwRead)==FALSE ) return DB_E_CANCELED;
               wszBuffer[(dwRead/sizeof(WCHAR))-1] = L'\0'; // terminate and remove newline

               _tcscpy( prop[0].szValue, W2CT(szItem) );
               if( wszBuffer[0] == L'0' ) {
                  _tcscpy( prop[1].szValue, W2CT(wszBuffer+2) );
               }
               else {
                  _tcscpy( prop[1].szValue, _T("") );
               }
               // Match the entry
               try 
               {
                  // Does it pass WHERE clause?
                  BOOL ok = eval.Evaluate(pTree->right->right, prop, sizeof(prop)/sizeof(EVALPROP));
                  if( ok ) {
                     // Get the assignment value from the assignment expression tree
                     CComVariant value = eval.GetValue(pTree->right->left->right, prop, sizeof(prop)/sizeof(EVALPROP));
                     value.ChangeType(VT_BSTR);

                     wcscpy( wszBuffer, L"SET ");
                     wcscat( wszBuffer, szItem );
                     wcscat( wszBuffer, L" ");
                     wcscat( wszBuffer, value.bstrVal );
                     wcscat( wszBuffer, L"\n" );
                     if( np.Write(wszBuffer, wcslen(wszBuffer)*sizeof(OLECHAR))==FALSE ) return DB_E_CANCELED;
                     DWORD dwRead;
                     if( np.Read(wszBuffer, sizeof(wszBuffer), &dwRead)==FALSE ) return DB_E_CANCELED;

                     cItems++;
                  }
               }
               catch( ... ) 
               {
                  return DB_E_ERRORSINCOMMAND;
               }
            }
            if( pcRowsAffected!=NULL ) *pcRowsAffected = cItems;
            return S_OK;
         }
      default:
         return DB_E_BADPARAMETERNAME;
      }
   }
};


#endif //__CDbRowset_H_
