// DS.h : Declaration of the CDbSource
#ifndef __CDbSource_H_
#define __CDbSource_H_

#include "resource.h"       // main symbols
#include "RS.h"


/////////////////////////////////////////////////////////////////////////////
// CDataSource

class ATL_NO_VTABLE CDbSource : 
   public CComObjectRootEx<CComSingleThreadModel>,
   public CComCoClass<CDbSource, &CLSID_ServerDb>,
   public IDBCreateSessionImpl<CDbSource, CDbSession>,
   public IDBInitializeImpl<CDbSource>,
   public IDBPropertiesImpl<CDbSource>,
   public IPersistImpl<CDbSource>,
   public IInternalConnectionImpl<CDbSource>
{
public:
   HRESULT FinalConstruct()
   {
      return FInit();
   }

DECLARE_REGISTRY_RESOURCEID(IDR_SERVERDB)

BEGIN_PROPSET_MAP(CDbSource)
   BEGIN_PROPERTY_SET(DBPROPSET_DATASOURCEINFO)
      PROPERTY_INFO_ENTRY(ACTIVESESSIONS)
      PROPERTY_INFO_ENTRY(DATASOURCEREADONLY)
      PROPERTY_INFO_ENTRY(BYREFACCESSORS)
      PROPERTY_INFO_ENTRY(OUTPUTPARAMETERAVAILABILITY)
      PROPERTY_INFO_ENTRY(PROVIDEROLEDBVER)
      PROPERTY_INFO_ENTRY(DSOTHREADMODEL)
      PROPERTY_INFO_ENTRY(SUPPORTEDTXNISOLEVELS)
      PROPERTY_INFO_ENTRY(USERNAME)
   END_PROPERTY_SET(DBPROPSET_DATASOURCEINFO)
   BEGIN_PROPERTY_SET(DBPROPSET_DBINIT)
      PROPERTY_INFO_ENTRY(AUTH_PASSWORD)
      PROPERTY_INFO_ENTRY(AUTH_PERSIST_SENSITIVE_AUTHINFO)
      PROPERTY_INFO_ENTRY(AUTH_USERID)
      PROPERTY_INFO_ENTRY(INIT_DATASOURCE)
      PROPERTY_INFO_ENTRY(INIT_HWND)
      PROPERTY_INFO_ENTRY(INIT_LCID)
      PROPERTY_INFO_ENTRY(INIT_LOCATION)
      PROPERTY_INFO_ENTRY(INIT_MODE)
      PROPERTY_INFO_ENTRY(INIT_PROMPT)
      PROPERTY_INFO_ENTRY(INIT_PROVIDERSTRING)
      PROPERTY_INFO_ENTRY(INIT_TIMEOUT)
   END_PROPERTY_SET(DBPROPSET_DBINIT)
   CHAIN_PROPERTY_SET(CDbCommand)
END_PROPSET_MAP()

BEGIN_COM_MAP(CDbSource)
   COM_INTERFACE_ENTRY(IDBCreateSession)
   COM_INTERFACE_ENTRY(IDBInitialize)
   COM_INTERFACE_ENTRY(IDBProperties)
   COM_INTERFACE_ENTRY(IPersist)
   COM_INTERFACE_ENTRY(IInternalConnection)
END_COM_MAP()

public:
};


#endif //__CDbSource_H_
