#if !defined(AFX_SIPWINDOW_H__20040801_0E4F_3B7E_3B8B_0080AD509054__INCLUDED_)
#define AFX_SIPWINDOW_H__20040801_0E4F_3B7E_3B8B_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CSipWindow : public CWindowImpl<CSipWindow, CStatic>
{
public:
   // Data members

   enum { KEY_TIMEOUT = 800 };  // 800 ms

   CBitmap m_bmp;
   int m_nButtons;
   RECT m_rcButtons[20];
   TCHAR m_szBitmapFile[MAX_PATH];
   CComPtr<IIMCallback> m_spCallback;
   //
   int m_nRepeat;           // How many times has the same button been repeated
   int m_iLastKey;          // Last button index
   bool m_bNextBig;         // Next letter is capialized
   DWORD m_dwLastTime;      // Timestamp of last key-press

   // Message map and handlers

   BEGIN_MSG_MAP(CSipWindow)
      MESSAGE_HANDLER(WM_CREATE, OnCreate)
      MESSAGE_HANDLER(WM_LBUTTONUP, OnButtonUp) 
   END_MSG_MAP()

   LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/)
   {
      LRESULT lResult = DefWindowProc(uMsg, wParam, lParam);
      if( !_LoadConfiguration() ) return 0;
      m_nRepeat = 0;
      m_iLastKey = -1;
      m_bNextBig = true;
      m_bmp = ::SHLoadImageFile(m_szBitmapFile);
      SetBitmap(m_bmp);
      return lResult;
   }
   LRESULT OnButtonUp(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
      for( int i = 0; i < m_nButtons; i++ ) {        
         typedef struct tagKEYROW 
         {
            BYTE vk[10];
         } KEYROW;
         static KEYROW Rows[] = 
         {
            /* 1 */ { VK_PERIOD, VK_COMMA, '?', '!' },
            /* 2 */ { 'A', 'B', 'C', '2', '' },
            /* 3 */ { 'D', 'E', 'F', '3', '' },
            /* 4 */ { 'G', 'H', 'I', '4' },
            /* 5 */ { 'J', 'K', 'L', '5' },
            /* 6 */ { 'M', 'N', 'O', '6', '' },
            /* 7 */ { 'P', 'Q', 'R', 'S', '7', ' ' },
            /* 8 */ { 'T', 'U', 'V', '8' },
            /* 9 */ { 'W', 'X', 'Y', 'Z' },
            /* < */ { '*', '+', '-' },
            /* 0 */ { ' ', '0', '#', '@', '/' },
            /* > */ { VK_BACK },
         };
         if( ::PtInRect(&m_rcButtons[i], pt) ) {
            // Timeout after a short period
            if( ::GetTickCount() - m_dwLastTime > KEY_TIMEOUT ) m_iLastKey = -1;
            if( i == m_iLastKey ) m_nRepeat++; else m_nRepeat = 0;
            // If repeated presses on same button we should remove the last char
            if( m_nRepeat > 0 ) {
               m_spCallback->SendVirtualKey(VK_BACK, KEYEVENTF_SILENT);
               m_spCallback->SendVirtualKey(VK_BACK, KEYEVENTF_SILENT | KEYEVENTF_KEYUP);
            }
            // Get the character from the array
            const KEYROW& row = Rows[i];
            BYTE ch = row.vk[m_nRepeat];
            switch( ch ) {
            case VK_TAB:
            case VK_BACK:
            case VK_SHIFT:
            case VK_DELETE:
            case VK_CONTROL:
            case VK_COMMA:
            case VK_SLASH:
            case VK_PERIOD:
            case VK_BACKQUOTE:
               {
                  m_spCallback->SendVirtualKey(ch, KEYEVENTF_SILENT);
                  m_spCallback->SendVirtualKey(ch, KEYEVENTF_SILENT | KEYEVENTF_KEYUP);
               }
               break;
            default:
               {
                  WCHAR wc = ch;
                  if( !m_bNextBig && IsCharAlpha(wc) ) ::CharLowerBuff(&wc, 1);
                  UINT uChar = wc;
                  UINT nShiftState = KeyStateDownFlag;
                  m_spCallback->SendCharEvents(ch, nShiftState, 1, &nShiftState, &uChar);
                  nShiftState = KeyStatePrevDownFlag | KeyShiftNoCharacterFlag;
                  m_spCallback->SendCharEvents(ch, nShiftState, 1, &nShiftState, &uChar);
               }
            }
            // Last key in sequence? Then we have a match!
            m_iLastKey = i;
            if( row.vk[m_nRepeat + 1] == '\0' ) m_iLastKey = -1;
            // Remember last time of keypress
            m_dwLastTime = ::GetTickCount();            
            // Automatically suggest lower/upper-case
            switch( ch ) {
            case VK_BACK:
            case VK_LEFT:
            case VK_RIGHT:
            case VK_SPACE:
               break;
            case '.':
            case '!':
            case '?':
            case VK_UP:
            case VK_DOWN:
            case VK_RETURN:
               m_bNextBig = true;
               break;
            default:
               m_bNextBig = false;
            }
            break;
         }
      }
      return 0;
   }

   // Implementation

   bool _LoadConfiguration()
   {
      m_nButtons = 0;
      m_szBitmapFile[0] = '\0';
      // Get the install path
      TCHAR szPath[MAX_PATH];
      ::GetModuleFileName(_Module.GetResourceInstance(), szPath, MAX_PATH);
      LPTSTR p = _tcsrchr(szPath, '\\');
      if( p == NULL ) return false;
      *(p + 1) = '\0';
      // Determine filename of configuration
      TCHAR szIniFile[MAX_PATH];
      _tcscpy(szIniFile, szPath);
      _tcscat(szIniFile, _T("phonesip.cfg"));
      // Read configuration from cfg file
      FILE* f = _tfopen(szIniFile, _T("rt"));
      if( f == NULL ) return false;
      TCHAR szLine[200] = { 0 };
      _fgetts(szLine, 199, f);
      TCHAR szFilename[MAX_PATH];
      _stscanf(szLine, _T("FILENAME=%s"), szFilename);
      ::wsprintf(m_szBitmapFile, _T("%s%s"), szPath, szFilename);
      while( !feof(f) ) {
         if( _fgetts(szLine, 199, f) == 0 ) break;
         _stscanf(szLine, _T("BUTTON=%d,%d,%d,%d"), 
            &m_rcButtons[m_nButtons].left,
            &m_rcButtons[m_nButtons].top,
            &m_rcButtons[m_nButtons].right,
            &m_rcButtons[m_nButtons].bottom);
         m_nButtons++;
      }
      ::fclose(f);
      return true;
   }
};


#endif // !defined(AFX_SIPWINDOW_H__20040801_0E4F_3B7E_3B8B_0080AD509054__INCLUDED_)
