// PhoneSip.cpp : Implementation of DLL Exports.


#include "stdafx.h"

#include "resource.h"
#include <INITGUID.H>
#include "sip.h"
#include "PhoneSip.h"

#include "IM.h"
#include <ce_setup.h>


CComModule _Module;

const CLSID CLSID_PhoneIM = { 0x42429667, 0xae04, 0x11d0, {0xa5, 0xfa, 0x00, 0xaa, 0x00, 0xa7, 0x49, 0xb9} };

BEGIN_OBJECT_MAP(ObjectMap)
   OBJECT_ENTRY(CLSID_PhoneIM, CPhoneIm)
END_OBJECT_MAP()


/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HANDLE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if( dwReason == DLL_PROCESS_ATTACH ) {
		_Module.Init(ObjectMap, (HINSTANCE) hInstance);
#ifndef UNDER_CE
      ::DisableThreadLibraryCalls( (HINSTANCE) hInstance );
#endif
	}
   if( dwReason == DLL_PROCESS_DETACH ) {
		_Module.Term();
   }
	return TRUE;    // ok
}


/////////////////////////////////////////////////////////////////////////////
// COM management

STDAPI DllCanUnloadNow(void)
{
	return _Module.GetLockCount() == 0 ? S_OK : S_FALSE;
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _Module.GetClassObject(rclsid, riid, ppv);
}

STDAPI DllRegisterServer(void)
{
	// registers object, typelib and all interfaces in typelib
	return _Module.RegisterServer(FALSE, &CLSID_PhoneIM);
}

STDAPI DllUnregisterServer(void)
{
	_Module.UnregisterServer();
	return S_OK;
}


////////////////////////////////////////////////////
// Install routines

EXTERN_C codeINSTALL_INIT Install_Init(
    HWND        hwndParent,
    BOOL        fFirstCall,
    BOOL        fPreviouslyInstalled,
    LPCTSTR     pszInstallDir)
{
   DllRegisterServer();
   return codeINSTALL_INIT_CONTINUE;
}

EXTERN_C codeINSTALL_EXIT Install_Exit(
    HWND    hwndParent,
    LPCTSTR pszInstallDir,
    WORD    cFailedDirs,
    WORD    cFailedFiles,
    WORD    cFailedRegKeys,
    WORD    cFailedRegVals,
    WORD    cFailedShortcuts)
{
   return codeINSTALL_EXIT_DONE;
}

EXTERN_C codeUNINSTALL_INIT Uninstall_Init(HWND hwndParent, LPCTSTR pszInstallDir)
{
   DllUnregisterServer();
   return codeUNINSTALL_INIT_CONTINUE;
}

EXTERN_C codeUNINSTALL_EXIT Uninstall_Exit(HWND hwndParent)
{
   return codeUNINSTALL_EXIT_DONE;
}

