#if !defined(AFX_SIP_H__20040418_4CE3_13BF_F6C7_0080AD509054__INCLUDED_)
#define AFX_SIP_H__20040418_4CE3_13BF_F6C7_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <sip.h>

#include "SipWindow.h"

#define BITMAP_WIDTH        240 
#define BITMAP_HEIGHT       80

EXTERN_C const CLSID CLSID_PhoneIM;


class CPhoneIm :
   public CComObjectRootEx<CComSingleThreadModel>,
   public CComCoClass<CPhoneIm, &CLSID_PhoneIM>,
   public IInputMethod
{
public:
   DECLARE_REGISTRY_RESOURCEID(IDR_PHONEIM)

BEGIN_COM_MAP(CPhoneIm)
   COM_INTERFACE_ENTRY(IInputMethod)
END_COM_MAP()

   // Data members

   SIPINFO m_SipInfo;;
   CComPtr<IIMCallback> m_spCallback;
   CSipWindow m_wndSip;
   CImageList m_ImagesWide;
   CImageList m_ImagesNarrow;

   // IInputMethod

   STDMETHOD(Select)(HWND hwndSip)
   {
      if( m_wndSip.IsWindow() ) return S_OK;
      m_wndSip.m_spCallback = m_spCallback;
      m_wndSip.Create(hwndSip, CWindow::rcDefault, NULL, WS_CHILD | SS_BITMAP | SS_NOTIFY);
      m_wndSip.ShowWindow(SW_SHOWNOACTIVATE); 
      return S_OK;
   }
   STDMETHOD(Deselect)(void)
   {
      if( m_wndSip.IsWindow() ) m_wndSip.DestroyWindow();
      if( !m_ImagesWide.IsNull() ) m_ImagesWide.Destroy();
      if( !m_ImagesNarrow.IsNull() ) m_ImagesNarrow.Destroy();
      return S_OK;
   }
   STDMETHOD(Showing)(void)
   {
      m_wndSip.m_bNextBig = true;
      return S_OK;
   }
   STDMETHOD(Hiding)(void)
   {
      return S_OK;
   }
   STDMETHOD(GetInfo)(IMINFO* pimi)
   {
      if( m_ImagesWide.IsNull () ) {
         m_ImagesWide.Create(32, 16, ILC_COLOR | ILC_MASK, 1, 1);
         m_ImagesNarrow.Create(16, 16, ILC_COLOR | ILC_MASK, 1, 1);
         CBitmap bm1;
         bm1.LoadBitmap(IDB_WIDE);
         m_ImagesWide.Add(bm1, RGB(192,192,192));
         CBitmap bm2;
         bm2.LoadBitmap(IDB_NARROW);
         m_ImagesNarrow.Add(bm2, RGB(192,192,192));
      }
      pimi->fdwFlags = SIPF_DOCKED;
      pimi->hImageNarrow = (HANDLE) (HIMAGELIST) m_ImagesNarrow;
      pimi->hImageWide = (HANDLE) (HIMAGELIST) m_ImagesWide;
      pimi->iNarrow = pimi->iWide = 0;
      ::SetRect(&pimi->rcSipRect, 0, 0, BITMAP_WIDTH, BITMAP_HEIGHT);
      return S_OK;
   }
   STDMETHOD(ReceiveSipInfo)(SIPINFO* psi)
   {
      m_wndSip.MoveWindow(0, 0, psi->rcSipRect.right - psi->rcSipRect.left, psi->rcSipRect.bottom - psi->rcSipRect.top, TRUE);
      m_SipInfo = *psi;
      return S_OK;
   }
   STDMETHOD(RegisterCallback)(IIMCallback* lpIMCallback)
   {
      m_spCallback = lpIMCallback;
      if( m_wndSip.IsWindow() ) m_wndSip.m_spCallback = m_spCallback;
      return S_OK;
   }
   STDMETHOD(GetImData)(DWORD /*dwSize*/, void* /*pvImData*/)
   {
      return E_NOTIMPL;
   }
   STDMETHOD(SetImData)(DWORD /*dwSize*/, void* /*pvImData*/)
   {
      return E_NOTIMPL;
   }
   STDMETHOD(UserOptionsDlg)(HWND /*hwndParent*/)
   {
      return E_NOTIMPL;
   }
};


#endif // !defined(AFX_SIP_H__20040418_4CE3_13BF_F6C7_0080AD509054__INCLUDED_)
