// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__860EAEC6_B42D_4805_B631_AE2D62F06AC2__INCLUDED_)
#define AFX_MAINFRM_H__860EAEC6_B42D_4805_B631_AE2D62F06AC2__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CMainFrame : 
   public CFrameWindowImpl<CMainFrame>, 
   public CUpdateUI<CMainFrame>,
   public CMessageFilter, 
   public CIdleHandler
{
public:
   DECLARE_FRAME_WND_CLASS(NULL, IDR_MAINFRAME)

   COutlookTestView m_view;

   virtual BOOL PreTranslateMessage(MSG* pMsg)
   {
      if(CFrameWindowImpl<CMainFrame>::PreTranslateMessage(pMsg))
         return TRUE;
      return m_view.PreTranslateMessage(pMsg);
   }
   virtual BOOL OnIdle()
   {
      UISetCheck(ID_VIEW_ICONS, m_view.m_ctrlPane.GetViewStyle()==LVS_ICON);
      UISetCheck(ID_VIEW_REPORT, m_view.m_ctrlPane.GetViewStyle()==LVS_REPORT);
      UIUpdateToolBar();
      return FALSE;
   }

   BEGIN_UPDATE_UI_MAP(CMainFrame)
      UPDATE_ELEMENT(ID_VIEW_TOOLBAR, UPDUI_MENUPOPUP)
      UPDATE_ELEMENT(ID_VIEW_ICONS, UPDUI_TOOLBAR | UPDUI_MENUPOPUP)
      UPDATE_ELEMENT(ID_VIEW_REPORT, UPDUI_TOOLBAR | UPDUI_MENUPOPUP)
   END_UPDATE_UI_MAP()

   BEGIN_MSG_MAP(CMainFrame)
      MESSAGE_HANDLER(WM_CREATE, OnCreate)
      COMMAND_ID_HANDLER(ID_APP_EXIT, OnFileExit)
      COMMAND_ID_HANDLER(ID_FILE_NEW, OnFileNew)
      COMMAND_ID_HANDLER(ID_FOLDER_NOTES, OnFolderNotes)
      COMMAND_ID_HANDLER(ID_VIEW_TOOLBAR, OnViewToolBar)
      COMMAND_ID_HANDLER(ID_VIEW_ICONS, OnViewIcons)
      COMMAND_ID_HANDLER(ID_VIEW_REPORT, OnViewReport)
      COMMAND_ID_HANDLER(ID_APP_ABOUT, OnAppAbout)
      CHAIN_MSG_MAP(CUpdateUI<CMainFrame>)
      CHAIN_MSG_MAP(CFrameWindowImpl<CMainFrame>)
   END_MSG_MAP()

   LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      HWND hWndToolBar = CreateSimpleToolBarCtrl(m_hWnd, IDR_MAINFRAME, FALSE, ATL_SIMPLE_TOOLBAR_PANE_STYLE);

      CreateSimpleReBar(ATL_SIMPLE_REBAR_NOBORDER_STYLE);
      AddSimpleReBarBand(hWndToolBar);

      m_hWndClient = m_view.Create(m_hWnd, rcDefault, NULL, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, WS_EX_CLIENTEDGE);

      UIAddToolBar(hWndToolBar);
      UISetCheck(ID_VIEW_TOOLBAR, 1);

      // register object for message filtering and idle updates
      CMessageLoop* pLoop = _Module.GetMessageLoop();
      ATLASSERT(pLoop != NULL);
      pLoop->AddMessageFilter(this);
      pLoop->AddIdleHandler(this);

      return 0;
   }

   LRESULT OnFolderNotes(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      AtlMessageBox(m_hWnd, _T("The notes folder was selected!"), _T("Outlook bar"), MB_ICONINFORMATION);
      return 0;
   }
   LRESULT OnFileExit(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      PostMessage(WM_CLOSE);
      return 0;
   }
   LRESULT OnFileNew(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      // TODO: add code to initialize document
      return 0;
   }
   LRESULT OnViewToolBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      static BOOL bVisible = TRUE;   // initially visible
      bVisible = !bVisible;
      CReBarCtrl rebar = m_hWndToolBar;
      int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST);   // toolbar is first 1st band
      rebar.ShowBand(nBandIndex, bVisible);
      UISetCheck(ID_VIEW_TOOLBAR, bVisible);
      UpdateLayout();
      return 0;
   }
   LRESULT OnViewIcons(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      m_view.m_ctrlPane.SetViewStyle(LVS_ICON);
      return 0;
   }
   LRESULT OnViewReport(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      m_view.m_ctrlPane.SetViewStyle(LVS_REPORT);
      return 0;
   }
   LRESULT OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      CAboutDlg dlg;
      dlg.DoModal();
      return 0;
   }
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__860EAEC6_B42D_4805_B631_AE2D62F06AC2__INCLUDED_)
