// OutlookTestView.h : interface of the COutlookTestView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_OUTLOOKTESTVIEW_H__AEF2DC55_5D21_4F98_94A3_8FA2153721FF__INCLUDED_)
#define AFX_OUTLOOKTESTVIEW_H__AEF2DC55_5D21_4F98_94A3_8FA2153721FF__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "OutlookBar.h"


class COutlookTestView : public COutlookBarImpl<COutlookTestView>
{
public:
   DECLARE_WND_SUPERCLASS(_T("WTL_OutlookCtrl"), GetWndClassName())  

   typedef COutlookBarImpl<COutlookTestView> parentClass;

   CImageListCtrl m_ImagesOutlookBig;
   CImageListCtrl m_ImagesOutlookSmall;
   CImageListCtrl m_ImagesFolders;

   COutlookPagerCtrl m_ctrlPager;
   COutlookPaneCtrl m_ctrlPane;
   CTreeViewCtrl m_ctrlTree;

   BOOL PreTranslateMessage(MSG* pMsg)
   {
      pMsg;
      return FALSE;
   }

   BEGIN_MSG_MAP(COutlookTestView)
      MESSAGE_HANDLER(WM_CREATE, OnCreate)
      NOTIFY_CODE_HANDLER(PGN_CALCSIZE, OnCalcSize)
      CHAIN_MSG_MAP( parentClass )
   ALT_MSG_MAP(1)
      CHAIN_MSG_MAP_ALT( parentClass, 1 )
   END_MSG_MAP()

   LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      LRESULT lRes = parentClass::OnCreate(uMsg, wParam, lParam, bHandled);

      m_ImagesOutlookBig.Create(IDB_OUTLOOK_BIG, 32, 1, RGB(255,0,0));
      m_ImagesOutlookSmall.Create(IDB_OUTLOOK_SMALL, 16, 1, RGB(255,0,0));
      m_ImagesFolders.Create(IDB_FOLDERS, 16, 1, RGB(255,0,255));

      m_ctrlPager.Create(m_hWnd, rcDefault);
      m_ctrlPane.Create(m_ctrlPager, rcDefault);
      _InitPane();
      m_ctrlPager.SetChild(m_ctrlPane);

      /*=- Alternative without the Pager control
      m_ctrlPane.Create(m_hWnd, rcDefault);
      _InitPane();

      InsertBand(0, _T("Navigation"), m_ctrlPane);
      InsertBand(1, _T("Files"), m_ctrlTree);
      */

      DWORD dwStyle = WS_CHILD | WS_VISIBLE | TVS_HASBUTTONS | TVS_HASLINES;
      m_ctrlTree.Create(m_hWnd, rcDefault, NULL, dwStyle);
      _InitTree();

      InsertBand(0, _T("Navigation"), m_ctrlPager);
      InsertBand(1, _T("Files"), m_ctrlTree);

      bHandled = TRUE;
      return lRes;
   }
   LRESULT OnCalcSize(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      // The pager control wants to know the optimal size
      // of the Outlook pane...
      LPNMPGCALCSIZE pCalcSize = (LPNMPGCALCSIZE) pnmh;
      switch( pCalcSize->dwFlag ) {
      case PGF_CALCHEIGHT:
         {
            RECT rc;
            m_ctrlPane.GetViewRect(&rc);
            pCalcSize->iHeight = rc.bottom-rc.top;
         }
         break;
      }
      return 0;
   }

   // Implementation

   void _InitTree()
   {
      m_ctrlTree.SetImageList(m_ImagesFolders, TVSIL_NORMAL);
      HTREEITEM hRoot, hItem;
      hRoot = m_ctrlTree.InsertItem(_T("TestProject"), 0, 0, TVI_ROOT, TVI_LAST);
      hItem = m_ctrlTree.InsertItem(_T("Source Files"), 0, 0, hRoot, TVI_LAST);
      m_ctrlTree.InsertItem(_T("Test.cpp"), 1, 1, hItem, TVI_LAST);
      m_ctrlTree.Expand(hItem);
      hItem = m_ctrlTree.InsertItem(_T("Header Files"), 0, 0, hRoot, TVI_LAST);
      m_ctrlTree.InsertItem(_T("Test.h"), 2, 2, hItem, TVI_LAST);
      m_ctrlTree.Expand(hItem);
      m_ctrlTree.Expand(hRoot);
   }
   void _InitPane()
   {
      //m_ctrlPane.SetExtendedPaneStyle(OPS_FIXEDTOPINDEX);
      m_ctrlPane.SetImageList(m_ImagesOutlookBig, LVSIL_NORMAL);
      m_ctrlPane.SetImageList(m_ImagesOutlookSmall, LVSIL_SMALL);
      m_ctrlPane.InsertItem(0, ID_FOLDER_INBOX, _T("Inbox"), 0);
      m_ctrlPane.InsertItem(1, ID_FOLDER_CALENDAR, _T("Calendar"), 1);
      m_ctrlPane.InsertItem(2, ID_FOLDER_CONTACTS, _T("My Personal Contacts"), 2);
      m_ctrlPane.InsertItem(3, ID_FOLDER_CHECKLIST, _T("Checklist"), 3);
      m_ctrlPane.InsertItem(4, ID_FOLDER_APPOINTMENTS, _T("Appointments"), 4);
      m_ctrlPane.InsertItem(5, ID_FOLDER_NOTES, _T("Notes"), 5);
      m_ctrlPane.InsertItem(6, ID_FOLDER_BIN, _T("Recycle Bin"), 6);
   }
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OUTLOOKTESTVIEW_H__AEF2DC55_5D21_4F98_94A3_8FA2153721FF__INCLUDED_)
