// NLSSystemFont.h : Declaration of the CSystemFont

#ifndef __SYSTEMFONT_H_
#define __SYSTEMFONT_H_

#include "resource.h"       // main symbols


/////////////////////////////////////////////////////////////////////////////
// CSystemFont

class ATL_NO_VTABLE CSystemFont : 
   public CComObjectRootEx<CComMultiThreadModel>,
   public CComCoClass<CSystemFont, &CLSID_SystemFont>,
   public ISupportErrorInfoImpl<&IID_IResource>,
   public IDispatchImpl<ISystemFont, &IID_ISystemFont, &LIBID_NLSLib>
{
public:
   CSystemFont()
   {
   }

DECLARE_REGISTRY(CInfo, "NLS.SystemFont", "NLS.SystemFont", IDS_SYSTEMFONT_DESCRIPTION, THREADFLAGS_BOTH)
DECLARE_NOT_AGGREGATABLE(CSystemFont)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CSystemFont)
   COM_INTERFACE_ENTRY(ISystemFont)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// CSystemFont
public:
   bool _IsWinNT351()
   {
      OSVERSIONINFO os;
      os.dwOSVersionInfoSize = sizeof(os);
      if( ::GetVersionEx(&os) ) {
         if( os.dwPlatformId!=VER_PLATFORM_WIN32_NT ) return false;
         return os.dwMajorVersion == 3;
      }
      else
        return false;
   };
   void _CopyFontInfo(FONTDESC &fd, LOGFONT &lf)
   {
      USES_CONVERSION;
      // Copy LOGFONT attributes to FONTDESC
      ocscpy( fd.lpstrName, T2OLE(lf.lfFaceName) );
      fd.sWeight = (short)lf.lfWeight;
      fd.sCharset = lf.lfCharSet;
      fd.fItalic = lf.lfItalic;
      fd.fUnderline = lf.lfUnderline;
      fd.fStrikethrough = lf.lfStrikeOut;

      long lfHeight = lf.lfHeight;
      if( lfHeight<0 ) lfHeight = -lfHeight;

      HDC dc = ::GetDC(NULL);
      int ppi = ::GetDeviceCaps(dc, LOGPIXELSY);
      fd.cySize.Lo = lfHeight * 720000 / ppi;
      fd.cySize.Hi = 0;
      ::ReleaseDC(NULL, dc);
   }


// ISystemFont
public:
   STDMETHOD(GetSystemFont)(/*[in]*/ SYSTEMFONTOPTION FontType, /*[out, retval]*/ IUnknown **pVal);
};

#endif //__SYSTEMFONT_H_
