// NLSSystemFont.cpp : Implementation of CSystemFont

#include "stdafx.h"

#include "NLS.h"
#include "NLSSystemFont.h"


/////////////////////////////////////////////////////////////////////////////
// CSystemFont

STDMETHODIMP CSystemFont::GetSystemFont(SYSTEMFONTOPTION FontType, IUnknown **pVal)
{
   ATLASSERT(pVal);
   if( pVal==NULL ) return E_POINTER;

   OLECHAR wszFontName[128] = { 0 };
   FONTDESC fd = { 0 };
   fd.cbSizeofstruct = sizeof(fd);
   fd.lpstrName = wszFontName;
   fd.sWeight = FW_NORMAL;
   fd.cySize.Hi = 140000;
   fd.cySize.Lo = 0;

   bool bFoundFont = false;

   NONCLIENTMETRICS ncm = {0};
   ncm.cbSize = sizeof(ncm);
   ::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, &ncm, 0);
   
   switch( FontType ) {
   case vbMessageBoxFont:
      _CopyFontInfo(fd, ncm.lfMessageFont);
      bFoundFont = true;
      break;
   case vbMenuFont:
      _CopyFontInfo(fd, ncm.lfMenuFont);
      bFoundFont = true;
      break;
   case vbStatusbarFont:
   case vbToolTipFont:
      _CopyFontInfo(fd, ncm.lfStatusFont);
      bFoundFont = true;
      break;
   }

   // In case of getting SystemFont, need to do some more snooping...
   if( !bFoundFont ) {
      HGDIOBJ hStock;
      bool bDeleteFont = false;
      if( !_IsWinNT351() ) {
         hStock = ::GetStockObject(DEFAULT_GUI_FONT);
         if( hStock==NULL ) hStock = ::GetStockObject(SYSTEM_FONT);
      }
      else {
         // Temporary fix since NT3.51 is very ugly with
         // SYSTEM FONT and low resolution...
         switch( ::GetThreadLocale() ) {
         case 1030: // danish
         case 1031: // german
         case 1033: // english (US)
         case 1036: // french
         case 1040: // italian
         case 1053: // swedish
         case 2055: // german (non standard)
         case 2057: // english (UK)
            // We can only switch fonts on non weirdo fontsets
            // So far we switch on european countries only...
            ocscpy( fd.lpstrName, L"MS Sans Serif" );
            // Re-use preinitalized font attributes for remaining of FONTDESC
            bFoundFont = true;
            break;
         case 1041: // japanese
            // Japanese NT3.51 really sucks, so we
            // simply choose a font which 'might' exist
            // on the machine!
            hStock = ::CreateFont(12, 0, 0, 0, FW_NORMAL, 0, 0, 0,
                                  SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                                  CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                                  DEFAULT_PITCH | FF_DONTCARE, _T("MS P Gothic"));
            bDeleteFont = true; // we created it, we should delete it too...
            break;
         default:
            hStock = ::GetStockObject(SYSTEM_FONT);
            break;
         };
      };
      if( !bFoundFont ) {
         LOGFONT lf = { 0 };
         int ok = ::GetObject( hStock, sizeof(lf), &lf );
         if( bDeleteFont ) ::DeleteObject(hStock);
         if( ok==0 ) return E_UNEXPECTED;
         _CopyFontInfo(fd, lf);
      }
   }

   return ::OleCreateFontIndirect(&fd, IID_IFontDisp, (LPVOID *)pVal);
}
