// NLSResource.h : Declaration of the CResource

#ifndef __RESOURCE_H_
#define __RESOURCE_H_

#include "resource.h"       // main symbols


/////////////////////////////////////////////////////////////////////////////
// CResource

class ATL_NO_VTABLE CResource : 
   public CComObjectRootEx<CComMultiThreadModel>,
   public CComCoClass<CResource, &CLSID_Resource>,
   public ISupportErrorInfoImpl<&IID_IResource>,
   public IDispatchImpl<IResource, &IID_IResource, &LIBID_NLSLib>
{
public:
   CResource()
   {
      m_hInstance = NULL;
   }

DECLARE_REGISTRY(CInfo, "NLS.Resource", "NLS.Resource", IDS_RESOURCE_DESCRIPTION, THREADFLAGS_BOTH)
DECLARE_NOT_AGGREGATABLE(CResource)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CResource)
   COM_INTERFACE_ENTRY(IResource)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// Attributes
public:
   CComBSTR m_bstrFilename;
   HINSTANCE m_hInstance; // HMODULE of loaded resource DLL

// CResource
public:
   inline BOOL _FileExists( LPCTSTR szFilename )
   {
      return( ::GetFileAttributes(szFilename)!=0xFFFFFFFF );
   };
   inline void _AppendCharIfMissing(LPTSTR pStr, TCHAR ch)
   {
      TCHAR s[2] = {ch,0};
      if( *::CharPrev(pStr, pStr + ::lstrlen(pStr))!=ch ) _tcscat(pStr, s);
   }
   TCHAR* _strchr(const TCHAR* p, TCHAR ch)
   {
      //strchr for '\0' should succeed
      while( *p != _T('\0') ) {
         if( *p == ch ) break;
         p = ::CharNext(p);
      }
      return (TCHAR*)((*p == ch) ? p : NULL);
   }
   TCHAR* _strstr(const TCHAR* pStr, const TCHAR* pCharSet)
   {
      int nLen = ::lstrlen(pCharSet);
      if( nLen==0 )  return (TCHAR*)pStr;

      const TCHAR* pRet = NULL;
      const TCHAR* pCur = pStr;
      while((pStr = _strchr(pCur, *pCharSet)) != NULL) {
         if( memcmp(pCur, pCharSet, nLen * sizeof(TCHAR)) == 0 ) {
            pRet = pCur;
            break;
         }
         pCur = ::CharNext(pCur);
      }
      return (TCHAR*) pRet;
   }
   BOOL _LoadResourceBitmap(HINSTANCE hInstance, 
                            TCHAR *pszString, 
                            HBITMAP &hBitmap,
                            HPALETTE &hPalette);
   HPALETTE _CreateDIBPalette (LPBITMAPINFO lpbmi, LPINT lpiNumColors);


// IResource
public:
   STDMETHOD(get_Filename)(/*[out, retval]*/ BSTR *pVal);
   STDMETHOD(get_hInstance)(/*[out, retval]*/ long *pVal);
   STDMETHOD(LocateResource)(/*[in]*/ long LCID, /*[in]*/ BSTR Path, /*[in]*/ BSTR Title, /*[out,retval]*/ BSTR *Filename);
   STDMETHOD(Init)(/*[in]*/ BSTR Filename);
   STDMETHOD(Close)();
   STDMETHOD(LoadResString)(/*[in]*/ long ID, /*[in]*/ BSTR Default, /*[out, retval]*/ BSTR *pVal);
   STDMETHOD(LoadResPicture)(/*[in]*/ long ID, /*[in]*/ short Type, /*[in, out]*/ IUnknown **pVal);
   STDMETHOD(FormatResString)(/*[in]*/ long ID, /*[in]*/ SAFEARRAY** ArgList, /*[out, retval]*/ BSTR *pVal);
};

#endif //__RESOURCE_H_
