// Locale.h : Declaration of the CLocale

#ifndef __Locale_H_
#define __Locale_H_

#include "resource.h"       // main symbols


/////////////////////////////////////////////////////////////////////////////
// CLocale

class ATL_NO_VTABLE CLocale : 
   public CComObjectRootEx<CComMultiThreadModel>,
   public CComCoClass<CLocale, &CLSID_Locale>,
   public ISupportErrorInfoImpl<&IID_ILocale>,
   public IDispatchImpl<ILocale, &IID_ILocale, &LIBID_NLSLib>
{
public:
   CLocale()
   {
      // The WIN32 docs reads:
      //  When a thread is created, it is given the system default thread locale. 
      //  The system reads the system default thread locale from the registry when the system boots. 
      //  This system default can be modified for future process and thread creation using Control Panel's International application. 
      m_lcid = ::GetThreadLocale();
   }

DECLARE_REGISTRY(CLocale, "NLS.Locale", "NLS.Locale", IDS_LOCALE_DESCRIPTION, THREADFLAGS_BOTH)
DECLARE_NOT_AGGREGATABLE(CLocale)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CLocale)
   COM_INTERFACE_ENTRY(ILocale)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// Attributes
public:
   LCID m_lcid;

// ILocale
public:
   STDMETHOD(get_LCID)(/*[out, retval]*/ long *pVal);
   STDMETHOD(put_LCID)(/*[in]*/ long newVal);
   STDMETHOD(get_Language)(/*[out, retval]*/ BSTR *pVal);
   STDMETHOD(get_MaxCharLength)(/*[out, retval]*/ long *pVal);
   STDMETHOD(GetInfo)(/*[in]*/ long Option, /*[out, retval]*/ BSTR *pVal);
   STDMETHOD(SetThreadLocale)();
   STDMETHOD(IsValidLocale)(/*[in]*/ long LCID, /*[out, retval]*/ VARIANT_BOOL *bRes);
};

#endif //__Locale_H_
