// TabPropertySheet.cpp : implementation file
//

#include "stdafx.h"
#include "TabPropertySheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CTabPropertySheet

CTabPropertySheet::CTabPropertySheet()
{
   m_nPages = 0;
}

CTabPropertySheet::~CTabPropertySheet()
{
}

BEGIN_MESSAGE_MAP(CTabPropertySheet, CTabCtrl)
   //{{AFX_MSG_MAP(CTabPropertySheet)
   ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnSelChange)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTabPropertySheet implementation

BOOL CTabPropertySheet::AddPage(LPCTSTR pstrTitle, CTabPropertyPage *pPage)
{
   ASSERT(pPage!=NULL);
   ASSERT(pstrTitle!=NULL);
   if( m_nPages>= sizeof(m_Pages)/sizeof(m_Pages[0]) ) return FALSE;

   m_Pages[m_nPages].pPage = pPage;

   // Load dialog templates for tab
   CDialogTemplate dt;
   HGLOBAL hDlg;
   // Instantiate
   dt.Load(pPage->m_lpszTemplateName);
   hDlg = dt.Detach();
   ::LockResource(hDlg);
   pPage->CreateIndirect(hDlg, this);
   ::UnlockResource(hDlg);
   ::GlobalFree(hDlg);

   CString s(pstrTitle);
   InsertItem(m_nPages, s);

   m_nPages++;

   LRESULT lRes;
   OnSelChange(NULL,&lRes);
   
   return TRUE;
};


/////////////////////////////////////////////////////////////////////////////
// CTabPropertySheet message handlers

void CTabPropertySheet::OnSelChange(NMHDR* pNMHDR, LRESULT* pResult) 
{
   int cur = GetCurSel();
   int i;
   for( i=0; i<m_nPages; i++ ) m_Pages[i].pPage->ShowWindow(SW_HIDE);
   CDialog *pDlg;
   pDlg = m_Pages[cur].pPage;
   CRect rcSize, rcOrg;
   pDlg->GetClientRect(&rcOrg);
   GetClientRect(&rcSize);
   int xpos = 2 + ((rcSize.Width()-rcOrg.Width())/2);
   int ypos = 2;
   CRect rc( xpos, ypos, xpos + rcOrg.Width(), ypos + rcOrg.Height());
   pDlg->MoveWindow(&rc,FALSE);
   pDlg->ShowWindow(SW_NORMAL);
   //
   *pResult = m_Pages[cur].pPage->OnSetActive();
}

