// ServerInfoTab.cpp : implementation file
//

#include "stdafx.h"

#include "NewsCounter.h"
#include "ServerInfoTab.h"
#include "nntp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CServerInfoTab dialog

IMPLEMENT_DYNAMIC(CServerInfoTab, CTabPropertyPage)

CServerInfoTab::CServerInfoTab()
   : CTabPropertyPage(CServerInfoTab::IDD)
{
#ifdef SIMULATE
   m_strServer = _T("news.test.com");
#else
   m_strServer = AfxGetApp()->GetProfileString(_T("Settings"),_T("Server"),_T("msnews.microsoft.com"));
#endif
   //{{AFX_DATA_INIT(CServerInfoTab)
   m_strPort = AfxGetApp()->GetProfileString(_T("Settings"),_T("Port"),_T("119"));
   m_strUsername = AfxGetApp()->GetProfileString(_T("Settings"),_T("Username"),_T(""));;
   m_strPassword = AfxGetApp()->GetProfileString(_T("Settings"),_T("Password"),_T(""));;
   m_nGroups = 0;
   //}}AFX_DATA_INIT
}


void CServerInfoTab::DoDataExchange(CDataExchange* pDX)
{
   CTabPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CServerInfoTab)
   DDX_Text(pDX, IDC_SERVER, m_strServer);
   DDV_MaxChars(pDX, m_strServer, 128);
   DDX_Text(pDX, IDC_PORT, m_strPort);
   DDV_MaxChars(pDX, m_strPort, 3);
   DDX_Text(pDX, IDC_PASSWORD, m_strPassword);
   DDV_MaxChars(pDX, m_strPassword, 64);
   DDX_Text(pDX, IDC_USERNAME, m_strUsername);
   DDV_MaxChars(pDX, m_strUsername, 64);
   DDX_Text(pDX, IDC_NRGROUPS, m_nGroups);
   DDV_MinMaxLong(pDX, m_nGroups, 0, 999999);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CServerInfoTab, CTabPropertyPage)
   //{{AFX_MSG_MAP(CServerInfoTab)
   ON_BN_CLICKED(IDC_UPDATEGROPS, OnUpdateGroups)
   ON_BN_CLICKED(IDC_DOWNLOADGROUPS, OnDownloadGroups)
   ON_WM_DESTROY()
   ON_EN_CHANGE(IDC_SERVER, OnChangeServer)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CServerInfoTab message handlers

BOOL CServerInfoTab::OnInitDialog() 
{
   CTabPropertyPage::OnInitDialog();
   
   GetGroupCount();
   
   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

void CServerInfoTab::GetGroupsCallback( int nCount, LPARAM pData )
{ 
   CServerInfoTab *pThis = (CServerInfoTab *)pData;
   ASSERT_KINDOF(CServerInfoTab, pThis);

   if( nCount % 100 == 0 ) {
      pThis->SetDlgItemInt(IDC_NRGROUPS, nCount, FALSE);
      HWND hWnd;
      pThis->GetDlgItem(IDC_NRGROUPS, &hWnd);
      ::UpdateWindow(hWnd);
   };
};

void CServerInfoTab::OnUpdateGroups() 
{
   UpdateData(TRUE);

   LPCTSTR pszUsername = NULL;
   LPCTSTR pszPassword = NULL;
   if( !m_strUsername.IsEmpty() ) pszUsername = m_strUsername;
   if( !m_strPassword.IsEmpty() ) pszPassword = m_strPassword;

   UINT nPort = _ttol(m_strPort);
   CWaitCursor wait;
   CNntpSession nntp;
   BOOL res;
   res = nntp.Connect(m_strServer, pszUsername, pszPassword, 0, nPort);
   if( res ) {
      CWaitCursor wait;
      CStringArray groups;
      groups.RemoveAll();
      nntp.GetGroups(groups, GetGroupsCallback, (LPARAM)this);
      nntp.Close();

      // Now, that we have the group list in the array,
      // write it to a file...
      CString sFilename( m_strServer );
      sFilename.Replace(_T('.'),_T('_'));
      sFilename += _T(".grp");
      CStdioFile f;
      if( f.Open(sFilename, CFile::modeCreate|CFile::modeWrite)==FALSE ) {
         AfxMessageBox(IDS_ERR_FILELOCKED, MB_ICONEXCLAMATION);
         return;
      };
      for( int i=0; i<groups.GetSize(); i++ ) {
         CString s(groups[i]);
         int pos = s.Find(_T(' '));
         if( pos>0 ) s = s.Left(pos);
         f.WriteString(s + _T("\n"));
      }
      f.Close();

      // Ok, we need to update group count on display
      m_nGroups = groups.GetSize();

      AfxMessageBox(IDS_GROUPDOWNLOADED, MB_ICONINFORMATION);
   }
   else {
      AfxMessageBox(IDS_ERR_NOCONTACT, MB_ICONEXCLAMATION);
   };

  UpdateData(FALSE);
}

void CServerInfoTab::OnDownloadGroups() 
{
   // TODO: Add your control notification handler code here   
}

void CServerInfoTab::OnDestroy() 
{
   // Save registry
   UpdateData();
   AfxGetApp()->WriteProfileString(_T("Settings"),_T("Server"),m_strServer);
   AfxGetApp()->WriteProfileString(_T("Settings"),_T("Port"),m_strPort);
   AfxGetApp()->WriteProfileString(_T("Settings"),_T("Username"),m_strUsername);
   AfxGetApp()->WriteProfileString(_T("Settings"),_T("Password"),m_strPassword);

   CTabPropertyPage::OnDestroy();
}


BOOL CServerInfoTab::GetGroupCount()
{
   UpdateData();
   CString sFilename( m_strServer );
   sFilename.Replace(_T('.'),_T('_'));
   sFilename += _T(".grp");
   CStdioFile f;
   m_nGroups = 0;
   if( f.Open(sFilename, CFile::modeRead)==TRUE) {
      CWaitCursor wait;
      CString s;
      long i=0;
      while( f.ReadString(s)==TRUE ) {
         s.TrimRight();
         if( !s.IsEmpty() ) {
            i++;
            if( i % 100 == 0 ) {
               SetDlgItemInt(IDC_NRGROUPS, i, FALSE);
               HWND hWnd;
               GetDlgItem(IDC_NRGROUPS, &hWnd);
               ::UpdateWindow(hWnd);
            };
         };
      }
      f.Close();
      m_nGroups = i;
   };
   UpdateData(FALSE);
   return TRUE;
};

void CServerInfoTab::OnChangeServer() 
{
   GetGroupCount();   
}
