// inet.h: interface for the extended internet classes.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INET_H__6CB1DEEA_8198_11D3_8291_0080AD509054__INCLUDED_)
#define AFX_INET_H__6CB1DEEA_8198_11D3_8291_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


//////////////////////////////////////////////////////////////////////
// CNntpSession


typedef void (*PNNTPGROUP)( int, LPARAM );

class CNntpSession : public CSocket
{
public:
   CNntpSession();

   BOOL Connect(LPCTSTR pstrServer,
                LPCTSTR pstrUserName = NULL, 
                LPCTSTR pstrPassword = NULL,
                DWORD dwContext = 0,
                UINT nPort = 119);

   BOOL GetGroups(CStringArray &Groups, 
                  PNNTPGROUP pGroupCallback=NULL,
                  LPARAM pData=0);
   CString SelectGroup(LPCTSTR pstrGroup);
   CString GetArticleHeaders();

   virtual void Close();

// Implementation
   ~CNntpSession();

protected:
   BOOL SendString(CString &s);
   BOOL SendString(LPCTSTR s);
   CString ReceiveString();
   BOOL CheckServerCode(int retcode);

protected:
   CString m_strServerName;
   CString m_strUserName;
   CString m_strPassword;
   //
   CString m_strCurrentGroup;
   //
   CString m_strBuffer;

public:
#ifdef _DEBUG
   virtual void Dump(CDumpContext& dc) const;
   virtual void AssertValid() const;
#endif

   DECLARE_DYNAMIC(CNntpSession)
};



#endif // !defined(AFX_INET_H__6CB1DEEA_8198_11D3_8291_0080AD509054__INCLUDED_)
