// inet.cpp: implementation of the CInternetSessionEx class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "NewsCounter.h"
#include "nntp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/////////////////////////////////////////////////////////////////////////////
// CNntpSession

CNntpSession::CNntpSession()
{
}

CNntpSession::~CNntpSession()
{
}

BOOL CNntpSession::Connect(LPCTSTR pstrServer,
                           LPCTSTR pstrUserName /*=NULL*/,
                           LPCTSTR pstrPassword /*=NULL*/, 
                           DWORD dwContext /*=0*/,
                           UINT nPort)
{
  ASSERT(AfxIsValidString(pstrServer));

 
   // Now create the socket. We first try the passed Port address,
   // then silently attempt to deduce the NNTP port and try with
   // that...
   BOOL ret = FALSE;
   ret = Socket(SOCK_STREAM, FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE);
   if( !ret ) return FALSE;
   ret = CSocket::Connect(pstrServer,nPort);
   if( !ret ) {
      struct servent FAR *   serventry;
      serventry = getservbyname( _T("nntp"), (LPTSTR)_T("tcp") );
      if( serventry ) nPort = ntohs(serventry->s_port);
      ret = CSocket::Connect(pstrServer,nPort);
   };
   if( !ret ) return FALSE;

   // Startup sequence...
   CString s;
   int retcode;
   while( TRUE ) {
      s = ReceiveString();
      if( !sscanf((LPCTSTR)s, _T("%u"), &retcode) ) {
         Close();
         return FALSE;
      };

       // check for innd, send 'mode reader' command
       // this is only necessary in unusual cases...
       if( s.Find(_T("InterNetNews")) >=0 &&
          s.Find(_T("NNRP"))<0 ) {
          SendString(_T("mode reader"));
          continue;
      }
       break;
   }
   if( retcode != 200 && retcode != 201 ) {   
      Close();
      return FALSE;
   };

   // Need to login?
   if( pstrUserName!=NULL ) {
      ASSERT(AfxIsValidString(pstrUserName));
      s.Format(_T("AUTHINFO user %s"), pstrUserName);
      SendString(s);
      s = ReceiveString();
      sscanf((LPCTSTR)s, _T("%u"), &retcode);
      if( (retcode==0) || (retcode>500) ) {
           Close();
         return FALSE;
      };
   }

   // Let's attempt to send the password if supplied
   if( (pstrUserName!=NULL) && (pstrPassword!=NULL) ) {
      ASSERT(AfxIsValidString(pstrPassword));
      s.Format(_T("AUTHINFO pass %s"), pstrPassword);
      SendString(s);
      s = ReceiveString();
      sscanf((LPCTSTR)s, _T("%u"), &retcode);
      if (retcode < 200 || retcode > 299) {
           Close();
         return FALSE;
      };
   }

   // Hmm...
   SendString(_T("XOVER"));
   s = ReceiveString();
   sscanf((LPCTSTR)s, _T("%u"), &retcode);

   // Assign internal variables
   m_strServerName = pstrServer;
   m_strUserName = pstrUserName;
   m_strPassword = pstrPassword;

  return TRUE;
}

void CNntpSession::Close()
{
   if( m_hSocket==NULL ) return;
   // Gracefully close 
   CString s;
   int retcode;
   if( SendString(_T("QUIT"))==TRUE ) {
     s = ReceiveString();
     sscanf((LPCTSTR)s, _T("%u"), &retcode);
     if( retcode!=205 ) {
       // Not a good return code... but who cares!
     };
   };
   // Close actual socket
   CSocket::Close();
}

BOOL CNntpSession::GetGroups(CStringArray &Groups,
                             PNNTPGROUP pGroupCallback/*=NULL*/,
                             LPARAM pData/*=0*/)
{
   ASSERT(m_hSocket);
   if( m_hSocket==NULL ) return FALSE;

   CString s;
   int retcode;
   s = _T("LIST");
   SendString(s);
   s = ReceiveString();
   sscanf((LPCTSTR)s, _T("%u"), &retcode);
   if( retcode != 215 ) {
      CheckServerCode(retcode);
       return FALSE;
   }

   //  Process a line received from the NNTP LIST command output.
   //  Each line from the LIST command has the form:
   //   <groupname> <highest_art_#> <lowest_art_#> {y|n|m}
   while( TRUE ) {
      s = ReceiveString();
      if( s==_T(".") ) break;
      Groups.Add(s);
      if( pGroupCallback!=NULL ) pGroupCallback(Groups.GetSize(), pData);
   };

   return TRUE;
};

CString CNntpSession::SelectGroup(LPCTSTR pstrGroup)
{
   ASSERT(m_hSocket);
   ASSERT(AfxIsValidString(pstrGroup));
   if( m_hSocket==NULL ) return CString();
   if( pstrGroup==NULL ) return CString();

   CString s;
   int retcode;
   s = CString(_T("GROUP ")) + pstrGroup;
   SendString(s);
   s = ReceiveString();
   sscanf((LPCTSTR)s, _T("%u"), &retcode);
   if( retcode != 211 ) {
      CheckServerCode(retcode);
        return CString();
   }
   return s;
};


BOOL CNntpSession::SendString(CString &s)
{
   return SendString((LPCTSTR)s);
};

BOOL CNntpSession::SendString(LPCTSTR pszText)
{
   ASSERT(AfxIsValidString(pszText));
   CString s(pszText);
   s += _T("\r\n");
   return Send((LPCTSTR)s,s.GetLength(),0);
};

CString CNntpSession::ReceiveString()
{
/*
  CString s;
  Receive(s.GetBuffer(1024), 1024, MSG_PEEK);
  s.ReleaseBuffer();
  int pos = s.Find(_T("\r\n"));
  if( pos<0 ) return CString();
  if( pos!=0 ) {
    Receive(s.GetBuffer(pos + 1), pos, 0);
    s.ReleaseBuffer(pos);
  }
  else
    s.Empty();
  TCHAR crlf[2];
  Receive(crlf, 2, 0);
*/
  CString s;
  int pos;
  pos = m_strBuffer.Find(_T("\r\n"));
  if( pos<0 ) {
    int len = Receive(s.GetBuffer(1024),1024,0);
    s.ReleaseBuffer(len);
    m_strBuffer += s;
  };
  pos = m_strBuffer.Find(_T("\r\n"));
  if( pos<0 ) return CString();
  s = m_strBuffer.Left(pos);
  m_strBuffer = m_strBuffer.Mid(pos+2);
  return s;
};

BOOL CNntpSession::CheckServerCode(int retcode)
{
   return TRUE;
};


#ifdef _DEBUG
void CNntpSession::Dump(CDumpContext& dc) const
{
   CSocket::Dump(dc);
   dc << "\nm_strServerName = " << m_strServerName;
   dc << "\nm_strUserName = " << m_strUserName;
   dc << "\nm_strPassword = " << m_strPassword;
}

void CNntpSession::AssertValid() const
{
}
#endif

IMPLEMENT_DYNAMIC(CNntpSession, CSocket)
