// NewsCountPage.cpp : implementation file
//

#include "stdafx.h"

#include "NewsCounter.h"
#include "NewsCountTab.h"
#include "nntp.h"
#include "Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TIMERID 111


/////////////////////////////////////////////////////////////////////////////
// CNewsCountTab dialog

IMPLEMENT_DYNAMIC(CNewsCountTab, CTabPropertyPage)

CNewsCountTab::CNewsCountTab()
   : CTabPropertyPage(CNewsCountTab::IDD)
{
   //{{AFX_DATA_INIT(CNewsCountTab)
   m_strFilter = AfxGetApp()->GetProfileString(_T("Settings"),_T("Filter"),_T(""));
   //}}AFX_DATA_INIT
   
   m_iThreadRunning = 0;
   m_bStopThread = FALSE;
   m_pActiveThread = NULL;
}

void CNewsCountTab::DoDataExchange(CDataExchange* pDX)
{
   CTabPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CNewsCountTab)
   DDX_Control(pDX, IDC_LIST, m_List);
   DDX_Text(pDX, IDC_EDIT1, m_strFilter);
   DDV_MaxChars(pDX, m_strFilter, 128);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNewsCountTab, CTabPropertyPage)
   //{{AFX_MSG_MAP(CNewsCountTab)
   ON_EN_CHANGE(IDC_EDIT1, OnChangeFilter)
   ON_WM_TIMER()
   ON_WM_DESTROY()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CNewsCountTab message handlers

BOOL CNewsCountTab::OnInitDialog() 
{
   CTabPropertyPage::OnInitDialog();
   
   CRect rect;
   m_List.GetClientRect(&rect);
   m_List.SetExtendedStyle(LVS_EX_FULLROWSELECT);

   CString s;
   s.LoadString(IDS_COL1);
   m_List.InsertColumn(0, s, LVCFMT_LEFT, rect.Width()-80);
   s.LoadString(IDS_COL2);
   m_List.InsertColumn(1, s, LVCFMT_RIGHT, 60);

   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

void CNewsCountTab::OnDestroy() 
{
   // Ask any running threads to stop
   m_bStopThread = TRUE;
   ::Sleep(0);

   CTabPropertyPage::OnDestroy();

   AfxGetApp()->WriteProfileString(_T("Settings"),_T("Filter"),m_strFilter);   
}

void CNewsCountTab::OnChangeFilter() 
{
   UpdateData(TRUE);
   // Reset timer, and set new timer...
   ::KillTimer(GetSafeHwnd(), TIMERID);
   ::SetTimer(GetSafeHwnd(), TIMERID, 500, NULL);
}

void CNewsCountTab::OnTimer(UINT nIDEvent) 
{
   if( nIDEvent==TIMERID ) {
      // Is there a thread running?
      if( m_iThreadRunning!=0 ) {
         TRACE("- Thread still running\n");
         // Signal to thread, that it should terminate
         m_bStopThread = TRUE;
         // Let timer live - to WM_TIMER us again later...
      }
      else {
         TRACE("- Thread not running\n");
         // Ready to rock...
         // First get rid of the timer
         ::KillTimer(GetSafeHwnd(), TIMERID);
         // then push off the new thread
         m_pActiveThread = AfxBeginThread( Thread1, this );
      }
   };
   CTabPropertyPage::OnTimer(nIDEvent);
}

BOOL CNewsCountTab::OnSetActive() 
{      
   OnChangeFilter(); // Trigger display update
   return CTabPropertyPage::OnSetActive();
}



/////////////////////////////////////////////////////////////////////////////
// Helper functions for threads

class CFlagHelper
// The helper class makes sure we update
// support variables when thread is leaving
{
public:
   CFlagHelper(CNewsCountTab *pParent) 
   { 
      TRACE("Thread Start\n");
      m_pParent = pParent; 
      m_pParent->lock.Lock();
      m_pParent->m_bStopThread = FALSE;
   };
   ~CFlagHelper() 
   { 
      TRACE("Thread stop\n");
      m_pParent->m_iThreadRunning=0; 
      m_pParent->m_pActiveThread = NULL;
      m_pParent->lock.Unlock();
   };
   CNewsCountTab *m_pParent;
};


BOOL MatchPattern( LPCTSTR String, LPCTSTR Pattern ) 
// Pattern matching.
// Look, this doesn't really work with MBCS so
// use UNICODE build if you need it.
{ 
    TCHAR c, p, l; 
    for (; ;) { 
       p = *Pattern;
       Pattern = _tcsinc(Pattern);
       switch( p ) { 
         case 0:                             // end of pattern 
             return *String ? FALSE : TRUE;  // if end of string TRUE 

         case _T('*'): 
             while (*String) {               // match zero or more char 
                 if( MatchPattern (String, Pattern) ) 
                     return TRUE; 
                 String = _tcsinc(String);
             } 
             return MatchPattern (String, Pattern); 

         case _T('?'): 
             if( *String == 0 )             // match any one char 
                 return FALSE;              // not end of string 
             String = _tcsinc(String);
             break; 

         case _T('['): 
             if ( (c = *String) == 0)      // match char set 
                 return FALSE;             // syntax 
             String = _tcsinc(String);

             c = _totupper(c); 
             l = 0; 
             while (p = *Pattern) { 
                 Pattern = _tcsinc(Pattern);
                 if (p == ']')               // if end of char set, then 
                     return FALSE;           // no match found 

                 if (p == _T('-')) {             // check a range of chars? 
                     p = *Pattern;               // get high limit of range 
                     if (p == 0  ||  p == ']') 
                         return FALSE;           // syntax 
                     if (c >= l  &&  c <= p) 
                         break;              // if in range, move on 
                 } 

                 l = p; 
                 if (c == p)                 // if char matches this element 
                     break;                  // move on 
             } 

             while (p  &&  p != _T(']')) {         // got a match in char set 
                 p = *Pattern;                     // skip to end of set 
                 Pattern = _tcsinc(Pattern);
             };
             break; 

         default: 
             c = *String; 
             String = _tcsinc(String);
             if( (TCHAR)_totupper(c) != p )              // check for exact char 
                 return FALSE;                   // not a match 
             break; 
        } 
    } 
} 


/////////////////////////////////////////////////////////////////////////////
// Thread #1 - Fill listbox w. filter

UINT Thread1( LPVOID pParam )
{
   TRACE("Thread Init\n");
   CNewsCountTab *pParent = (CNewsCountTab *)pParam;
   ASSERT_KINDOF(CNewsCountTab, pParent);
   CFlagHelper helper( pParent );
   pParent->m_iThreadRunning = 1;
   ASSERT_KINDOF(CServerInfoTab, &(pParent->m_pDlg->m_Dlg2));

   CString strFilename( pParent->m_pDlg->m_Dlg2.m_strServer );
   if( strFilename.IsEmpty() ) return 1;
   strFilename.Replace(_T('.'),_T('_'));
   strFilename += _T(".grp");

   // Prepare a listview item for insert
   LVITEM itm = { 0 };
   itm.mask = LVIF_TEXT | LVIF_PARAM;

   // Setup filter (wrap * around and make uppercase)
   CString sFilter;
   sFilter.Format(_T("*%s*"), pParent->m_strFilter );
   sFilter.MakeUpper();

   // Remove all items in list
   pParent->m_List.DeleteAllItems();

   // Ok, read the complete group file
   CStdioFile f;
   if( f.Open( strFilename, CFile::modeRead)==FALSE ) return 1;
   CString s;
   int i=-1; // will be i=0 in a moment

   while( f.ReadString(s) ) {
      i++;

      s.TrimRight();
      if( s.IsEmpty() ) continue;

      if( MatchPattern(s, sFilter) ) {
         itm.pszText = (LPTSTR)(LPCTSTR)s;
         itm.cchTextMax = s.GetLength();
         itm.lParam = i;
         pParent->m_List.InsertItem(&itm);
      };

      // Someone asking us to quit thread?      
      if( pParent->m_bStopThread ) {
         f.Abort();
         return 2;
      };
   };
   f.Close();
  
   // Start next thread - the one which
   // collects article count for each group
   pParent->m_pActiveThread = AfxBeginThread( Thread2, pParent );   

   return 0;
};


/////////////////////////////////////////////////////////////////////////////
// Thread #2 - Update "available" in listbox

UINT Thread2( LPVOID pParam )
{
   CNewsCountTab *pParent = (CNewsCountTab *)pParam;
   ASSERT_KINDOF(CNewsCountTab, pParent);
   CFlagHelper helper( pParent );
   pParent->m_iThreadRunning = 2;
   ASSERT_KINDOF(CServerInfoTab, &(pParent->m_pDlg->m_Dlg2));

   // Extract servername, port, username and password
   CString sServer( pParent->m_pDlg->m_Dlg2.m_strServer );
   LPCTSTR pszUsername = NULL;
   LPCTSTR pszPassword = NULL;
   if( !pParent->m_pDlg->m_Dlg2.m_strUsername.IsEmpty() ) pszUsername = pParent->m_pDlg->m_Dlg2.m_strUsername;
   if( !pParent->m_pDlg->m_Dlg2.m_strPassword.IsEmpty() ) pszPassword = pParent->m_pDlg->m_Dlg2.m_strPassword;
   UINT nPort = _ttol(pParent->m_pDlg->m_Dlg2.m_strPort);

   CNntpSession nntp;
   BOOL res;
#ifndef SIMULATE
   res = nntp.Connect(sServer, pszUsername, pszPassword, 0, nPort);
#else
   res = TRUE;
#endif
   if( res ) {

      // Get number of groups in the list in total
      int nCount = pParent->m_List.GetItemCount();

      // Use a CByteArray to keep track of visited groups
      // (could have been done smarter...)
      CByteArray Visited;
      Visited.SetSize(nCount);

      // Ok, we start at the top
      int nStartPos, i;
      nStartPos = i = pParent->m_List.GetTopIndex();

      while( TRUE ) {

         if( !Visited[i] ) {
            LVITEM itm;
            CString sGroup;
            ::ZeroMemory(&itm,sizeof(itm));
            itm.iItem = i;
            itm.iSubItem = 0;
            itm.mask = LVIF_TEXT | LVIF_PARAM;
            itm.pszText = sGroup.GetBuffer(512);
            itm.cchTextMax = 512;
            pParent->m_List.GetItem(&itm);
            sGroup.ReleaseBuffer();

            CString s;
#ifndef SIMULATE
            s = nntp.SelectGroup(sGroup);
#else
            s = _T("221 56");
            ::Sleep(180);  // simulate net lag :)
#endif
            UINT nRetCode;
            UINT nGroupCount = 0;
            if( !s.IsEmpty() ) {
               ::sscanf((LPCTSTR)s, _T("%u %u"), &nRetCode, &nGroupCount);

               s.Format(_T("%d"), nGroupCount);
               itm.mask = LVIF_TEXT;
               itm.iSubItem = 1;
               itm.pszText = (LPTSTR)(LPCTSTR)s;
               itm.cchTextMax = s.GetLength();
               pParent->m_List.SetItem(&itm);

               Visited[i] = TRUE;
            };
         };

         // Next item please
         i++;
         // If we're at the bottom, wrap around and start
         // with first item
         if( i>=nCount ) i=0;
         // If we are at the start position once again,
         // then we've been through the whole list.
         if( i==nStartPos ) break;

         // Did the top visible item change
         int nPos = pParent->m_List.GetTopIndex();
         if( nPos!=nStartPos ) nStartPos = i = nPos;

         // Someone asking us to quit thread?
         if( pParent->m_bStopThread ) {
            nntp.Close();
            return 3;
         };
      
      };
      nntp.Close();
      return 0;
   }
   else
      return 1;
};

