// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__7FF89DB2_92AC_437E_B3F2_6DFB121FB7C8__INCLUDED_)
#define AFX_MAINFRM_H__7FF89DB2_92AC_437E_B3F2_6DFB121FB7C8__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000



class CMainFrame : 
   public CFrameWindowImpl<CMainFrame>, 
   public CUpdateUI<CMainFrame>,
	public CMessageFilter, 
   public CIdleHandler
{
public:
	DECLARE_FRAME_WND_CLASS(NULL, IDR_MAINFRAME)

   enum 
   { 
      MAX_CHARS = 20,
      MAX_LINES = 5,
   };

   enum
   {
      PLAYING = 1,
      EATEN,
      DROWNING,
      SQUASHED,
   };

   typedef struct tagLINEINFO
   {
      int line_curpos;
      int line_oldpos;
      int line_speed;
      //
      int croc_eat;
      int croc_above;
      int croc_dive;
      //
      int fly_appear;
      int fly_pos;
   } LINEINFO;

   typedef struct tagSCENE 
   {
      CHAR title[100];
      CHAR top[MAX_CHARS + 100];
      LPSTR lines[MAX_LINES - 1];
      LINEINFO info[MAX_LINES - 1];
      POINT frog_pos;
      int stage;
      int houses;
      int time;
      POINT bonus_pos;
      int showbonus;
      int fly_bonus;
      DWORD dwRand;
      bool initialized;
   } SCENE;

   CFont m_font;
   TCHAR m_szPath[MAX_PATH];
   CHAR m_wKey;
   CHAR m_szLines[MAX_LINES][MAX_CHARS + 50];
   int m_GameState;
   int m_iScore;
   int m_iBonus;
   int m_iHighScore;
   int m_iStage;
   int m_iLives;
   int m_iHuseFuldt;
   int m_HusPos[8];
   SCENE m_scene;
   DWORD m_dwTickStart;
   DWORD m_dwTickStage;
   CTcpip m_socket;

   void GameLoop();
   void SendScreen();

   void _ClearScreen();
   void _PressAnyKey();
   void _Scene();
   void _GameOver();
   void _LoadScene();
   void _YouDied();
   void _StageComplete();
   void _GameComplete();
   void _PlaySound(LPCSTR pstrWave);

	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL OnIdle();

	BEGIN_UPDATE_UI_MAP(CMainFrame)
	END_UPDATE_UI_MAP()

	BEGIN_MSG_MAP(CMainFrame)
		MESSAGE_HANDLER(WM_CREATE, OnCreate)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBkgnd)
		MESSAGE_HANDLER(WM_TIMER, OnTimer)
		MESSAGE_HANDLER(WM_KEYDOWN, OnKeyDown)
		COMMAND_ID_HANDLER(ID_APP_EXIT, OnFileExit)
		COMMAND_ID_HANDLER(ID_FILE_NEW, OnFileNew)
		COMMAND_ID_HANDLER(ID_APP_ABOUT, OnAppAbout)
		CHAIN_MSG_MAP(CUpdateUI<CMainFrame>)
		CHAIN_MSG_MAP(CFrameWindowImpl<CMainFrame>)
	END_MSG_MAP()

	LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnClose(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnPaint(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnEraseBkgnd(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnTimer(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnKeyDown(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnFileExit(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnFileNew(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__7FF89DB2_92AC_437E_B3F2_6DFB121FB7C8__INCLUDED_)
