// MainFrm.cpp : implmentation of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "aboutdlg.h"
#include "MainFrm.h"

#define DISPLAY_IP   "192.2.2.71"
#define DISPLAY_PORT 2001 

#define DISPLAY_UPDATE_MS 300


WSAInit init;



BOOL CMainFrame::PreTranslateMessage(MSG* pMsg)
{
	return CFrameWindowImpl<CMainFrame>::PreTranslateMessage(pMsg);
}

BOOL CMainFrame::OnIdle()
{
	return FALSE;
}

LRESULT CMainFrame::OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	CMessageLoop* pLoop = _Module.GetMessageLoop();
	ATLASSERT(pLoop != NULL);
	pLoop->AddMessageFilter(this);
	pLoop->AddIdleHandler(this);

   ::GetModuleFileName(NULL, m_szPath, MAX_PATH);
   LPSTR p = strrchr(m_szPath, '\\');
   if( p ) *(p + 1) = '\0';

   TCHAR szIniFile[MAX_PATH];
   sprintf(szIniFile, "%sSettings.ini", m_szPath);
   CHAR szIpAddress[100] = { 0 };
   ::GetPrivateProfileString("Settings", "IPAddress", DISPLAY_IP, szIpAddress, 99, szIniFile);
   int iIpPort = ::GetPrivateProfileInt("Settings", "IPPort", DISPLAY_PORT, szIniFile);
   int iUpdateSpeed = ::GetPrivateProfileInt("Settings", "UpdateSpeed", DISPLAY_UPDATE_MS, szIniFile);
   m_iHighScore = ::GetPrivateProfileInt("GameInfo", "HighScore", 0, szIniFile);

   m_socket.Open(iIpPort, szIpAddress);
   ATLASSERT(!m_socket.IsNull());

   SetTimer(1, iUpdateSpeed);

   CLogFont lf = AtlGetStockFont(OEM_FIXED_FONT);
   strcpy(lf.lfFaceName, "Terminal");
   lf.lfWidth = 32;
   lf.lfHeight = 32;
   m_font.CreateFontIndirect(&lf);

   m_GameState = 0;
   m_wKey = 0;
   m_iScore = 0;

   _ClearScreen();

   ResizeClient(400, 200);

   _PlaySound("start.wav");

	return 0;
}

LRESULT CMainFrame::OnClose(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled)
{
   CHAR szIniFile[MAX_PATH];
   sprintf(szIniFile, "%sSettings.ini", m_szPath);
   CHAR szBuffer[100];
   sprintf(szBuffer, "%d", m_iHighScore);
   ::WritePrivateProfileString("GameInfo", "HighScore", szBuffer, szIniFile);

   m_socket.Close();

   bHandled = FALSE;
   return 0;
}

LRESULT CMainFrame::OnEraseBkgnd(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   CDCHandle dc = (HDC) wParam;
   RECT rcClient;
   GetClientRect(&rcClient);
   dc.FillSolidRect(&rcClient, RGB(0,0,0));
   return 0;
}

LRESULT CMainFrame::OnPaint(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   CPaintDC dc = m_hWnd;
   dc.SetTextColor(RGB(200,100,50));
   dc.SetBkMode(TRANSPARENT);
   HFONT hOldFont = dc.SelectFont(m_font);
   int y = 20;
   for( int i = 0; i < MAX_LINES; i++ ) {
      dc.TextOut(20, y, m_szLines[i], MAX_CHARS);
      y += 32;
   }
   dc.SelectFont(hOldFont);
   return 0;
}

LRESULT CMainFrame::OnTimer(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   GameLoop();
   SendScreen();
   Invalidate();
   return 0;
}

LRESULT CMainFrame::OnKeyDown(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   m_wKey = wParam;
   return 0;
}

LRESULT CMainFrame::OnFileExit(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT CMainFrame::OnFileNew(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: add code to initialize document

	return 0;
}

LRESULT CMainFrame::OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	CAboutDlg dlg;
	dlg.DoModal();
	return 0;
}


void CMainFrame::SendScreen()
{
   if( m_socket.IsNull() ) return;

   char text_preamble[] = {
         0x0F // Initiate address mode
       , 0x20 // Add address of unit to this
       , 0x0E // Terminate address mode
       , 0x02 // Initiate text mode    
       , 0x20 // Add buffer pos here (eg. to start writing at char pos 5, this must be 0x25)
       //, 0x00
   };

   char text_postamble[] = {    
         0x03 // Terminate text mode
       , 0x09 // Terminate comms
       , 0x00
   }; 

   m_socket.Write(&text_preamble, sizeof(text_preamble));

   for( int i = 0; i < MAX_LINES; i++ ) {
      m_socket.Write(&m_szLines[i], MAX_CHARS); 
   }

   m_socket.Write(&text_postamble, sizeof(text_postamble));
}

