
#include "stdafx.h"
#include "resource.h"

#include "mainfrm.h"


void CMainFrame::GameLoop()
{
   switch( m_GameState ) {
   case 0:
      _PressAnyKey();
      break;
   case 1:
      _Scene();
      break;
   case 2:
      _GameOver();
      break;
   case 3:
      _YouDied();
      break;
   case 4:
      _StageComplete();
      break;
   case 5:
      _GameComplete();
      break;
   }
}

void CMainFrame::_ClearScreen()
{
   memset(m_szLines, ' ', sizeof(m_szLines));
   *( ((LPSTR) m_szLines) + sizeof(m_szLines) - 1) = '\0';
}

void CMainFrame::_PressAnyKey()
{
   if( m_wKey == ' ' || isalpha(m_wKey) || m_wKey == VK_RETURN ) m_GameState = 1;
   _ClearScreen();
   strcpy(m_szLines[1], "     PRESS  ANY      ");
   strcpy(m_szLines[2], "    KEY TO BEGIN     ");
   m_iScore = 0;
   m_iBonus = 0;
   m_iStage = 1;
   m_iLives = 3;
   m_iHuseFuldt = 0;
   ::ZeroMemory(&m_scene, sizeof(m_scene));
   m_wKey = 0;
}

void CMainFrame::_Scene()
{
   DWORD dwTick = ::GetTickCount();
   int oldstage = m_scene.stage;
   int oldstate = m_GameState;

   if( !m_scene.initialized ) _LoadScene();

   _ClearScreen();

   if( m_GameState == 5 ) return;

   int frog_anim = ' ';

   if( m_scene.stage == SQUASHED )
   {
      switch( (dwTick - m_dwTickStage) / 800 )
      {
      case 0: frog_anim = 'O'; break;
      case 1: frog_anim = '\xB8'; break;
      case 2: frog_anim = 'X'; break;
      case 3: frog_anim = 'x'; break;
      default:
         m_GameState = 3;
         break;
      }
   }

   if( m_scene.stage == EATEN )
   {
      switch( (dwTick - m_dwTickStage) / 800 )
      {
      case 0: frog_anim = 'O'; break;
      case 1: frog_anim = ' '; break;
      case 2: frog_anim = 'O'; break;
      case 3: frog_anim = ' '; break;
      default:
         m_GameState = 3;
         break;
      }
   }

   if( m_scene.stage == DROWNING )
   {
      switch( (dwTick - m_dwTickStage) / 800 )
      {
      case 0: frog_anim = 'O'; break;
      case 1: frog_anim = '*'; break;
      case 2: frog_anim = 'o'; break;
      case 3: frog_anim = '.'; break;
      default:
         m_GameState = 3;
         break;
      }
   }

   // Paint static top line
   strncpy(m_szLines[0], m_scene.top, MAX_CHARS);

   // Put frogs in completed houses
   for( int h = 0; h < m_iHuseFuldt; h++ ) m_szLines[0][ m_HusPos[h] ] = '\x94';

   // Scroll and paint lines
   for( int i = 0; i < MAX_LINES - 1; i++ ) {
      int iLen = strlen(m_scene.lines[i]) - 1;
      int iSpeed = m_scene.info[i].line_speed;

      int pos = 0;
      if( iSpeed != 0 )
      {
         double d = (long) (dwTick - m_dwTickStart) / (double) iSpeed;
         pos = (int) d;
      }
      else
      {
         pos = m_scene.info[i].line_curpos;
      }

      m_scene.info[i].line_oldpos = m_scene.info[i].line_curpos;
      m_scene.info[i].line_curpos = pos;
      while( pos < 0 ) pos += iLen;

      for( int x = 0; x < MAX_CHARS; x++ ) {
         m_szLines[i + 1][x] = m_scene.lines[i][pos % iLen];
         pos++;
      }
   }

   // Determine time left
   int time_left = m_scene.time - ( (long) (dwTick - m_dwTickStage) / 1000);
   if( time_left < 0 ) time_left = 0;

   // Print time
   if( m_scene.stage == PLAYING 
       && (m_scene.frog_pos.y < MAX_LINES - 1 || m_scene.frog_pos.x < 13) )
   {
      sprintf(&m_szLines[MAX_LINES - 1][MAX_CHARS - 2], "%02d", time_left);
      if( time_left == 0 ) m_scene.stage = SQUASHED;
   }

   // Scroll frog
   if( m_scene.stage == PLAYING || m_scene.stage == EATEN )
   {
      if( m_scene.frog_pos.y > 0 )
      {
         int diff = m_scene.info[ m_scene.frog_pos.y - 1 ].line_curpos - m_scene.info[ m_scene.frog_pos.y - 1 ].line_oldpos;
         m_scene.frog_pos.x -= diff;
      }
   }

   // While still playing
   if( m_scene.stage == PLAYING )
   {      
      int i, j;

      // Animate frog when staying still
      frog_anim = 0x94;
      if( (dwTick % 4) == 0 ) frog_anim = 0x93;
      if( (dwTick % 7) == 0 ) frog_anim = 0x95;

      switch( ((dwTick - m_dwTickStage) / 800) % 50 )
      {
         case 18: frog_anim = 0x93; break;
         case 24: frog_anim = 0x95; break;
         case 30: frog_anim = 0xE2; break;
         case 35: frog_anim = 0xE3; break;
         case 43: frog_anim = 0x84; break;
         case 49: frog_anim = 0x85; break;
      }

      // Navigate frog
      switch( m_wKey )
      {
         case VK_LEFT:
            if( m_scene.frog_pos.x > 0 ) {
               _PlaySound("hop.wav");
               m_scene.frog_pos.x--;
            }
            break;
         case VK_RIGHT:
            if( m_scene.frog_pos.x < MAX_CHARS - 1 ) {
               _PlaySound("hop.wav");
               m_scene.frog_pos.x++;
            }
            break;
         case VK_UP:
            if( m_scene.frog_pos.y > 0 ) {
               _PlaySound("hop.wav");
               m_scene.frog_pos.y--;
            }
            frog_anim = 0x7F;
            break;
         case VK_DOWN:
            if( m_scene.frog_pos.y < MAX_LINES - 1 ) {
               _PlaySound("hop.wav");
               m_scene.frog_pos.y++;
            }
            frog_anim = 0x59;
            break;
      }

      // Paint diving croc
      for( i = 0; i < MAX_LINES - 1; i++ ) {
         if( m_scene.info[i].croc_above > 0 && m_scene.info[i].line_speed != 0 ) {
            int iDiveAnim = (dwTick + 1234) % m_scene.info[i].croc_above;
            int iDivePeriod = m_scene.info[i].croc_dive;
            if( iDiveAnim < iDivePeriod ) {
               for( j = 0; j < MAX_CHARS; j++ ) {
                  switch( m_szLines[i + 1][j] ) {
                  case '\xAE':
                  case '\xAF':
                     if( iDiveAnim < 700 ) m_szLines[i + 1][j] = '-';
                     else if( iDiveAnim > iDivePeriod - 700 ) m_szLines[i + 1][j] = '-';
                     else m_szLines[i + 1][j] = ' ';
                     break;
                  case '\xB0':
                     m_szLines[i + 1][j] = ' ';
                     break;
                  case '8':
                     if( iDiveAnim < 700 ) m_szLines[i + 1][j] = ';';
                     else if( iDiveAnim > iDivePeriod - 700 ) m_szLines[i + 1][j] = ';';
                     else m_szLines[i + 1][j] = ' ';
                     break;
                  case '\xB1':
                     if( iDiveAnim < 500 ) m_szLines[i + 1][j] = '\xB0';
                     else if( iDiveAnim > iDivePeriod - 500 ) m_szLines[i + 1][j] = '\xB0';
                     else m_szLines[i + 1][j] = ' ';
                     break;
                  }
               }
            }
         }
      }

      // Paint eating croc
      for( i = 0; i < MAX_LINES - 1; i++ ) {
         if( m_scene.info[i].croc_eat > 0 && m_scene.info[i].line_speed != 0 ) {
            int iEatAnim = dwTick % m_scene.info[i].croc_eat;
            if( iEatAnim < 3000 ) {
               for( j = 0; j < MAX_CHARS; j++ ) {
                  switch( m_szLines[i + 1][j] ) {
                  case '\xAE':
                     if( ((iEatAnim / 500) & 1) != 0 ) m_szLines[i + 1][j] = '=';
                     else m_szLines[i + 1][j] = '>';
                     break;
                  case '\xAF':
                     if( ((iEatAnim / 500) & 1) != 0 ) m_szLines[i + 1][j] = '=';
                     else m_szLines[i + 1][j] = '<';
                     break;
                  }
               }
            }
         }
      }

      // Paint fly
      for( i = 0; i < MAX_LINES - 1; i++ ) {
         if( m_scene.info[i].fly_appear > 0 ) {
            int diff = m_scene.info[i].line_curpos - m_scene.info[i].line_oldpos;
            int iFlyAnim = (dwTick + m_scene.dwRand) % m_scene.info[i].fly_appear;
            if( iFlyAnim < 8000 ) {
               if( m_scene.info[i].fly_pos == 0 ) {
                  if( m_scene.info[i].line_speed > 0 ) m_scene.info[i].fly_pos = 23;
                  else m_scene.info[i].fly_pos = 1;
               }
               m_scene.info[i].fly_pos -= diff;
               int pos = m_scene.info[i].fly_pos - 1;
               if( pos >= 0 && pos < MAX_CHARS && m_szLines[i + 1][pos] == '\xB2' ) 
               {
                  m_szLines[i + 1][pos] = '\xA9';
                  if( ((dwTick / 400) & 1) != 0 ) m_szLines[i + 1][pos] = '\xB8';
               }
            }
            else {
               m_scene.info[i].fly_pos = 0;
            }
         }
      }

      // Paint flashing bonus sign
      if( m_scene.showbonus > 0 ) {
         if( ((dwTick / 400) & 1) != 0 ) {
            char szBuffer[100];
            sprintf(szBuffer, "%d", m_scene.fly_bonus);
            strncpy(&m_szLines[ m_scene.bonus_pos.y ][ m_scene.bonus_pos.x ], szBuffer, strlen(szBuffer));
         }
         --m_scene.showbonus;
      }

      // Determine if frog has died
      char under_frog = m_szLines[ m_scene.frog_pos.y ][ m_scene.frog_pos.x ];

      switch( under_frog )
      {
         case ' ':
            m_scene.stage = DROWNING;
            break;
         case '\xA9':
         case '\xB8':
            for( i = 0; i < MAX_LINES - 1; i++ ) {
               m_scene.info[i].fly_appear = 0;
            }
            m_scene.showbonus = 6;
            m_iBonus += m_scene.fly_bonus;
            m_scene.bonus_pos.x = max(0, m_scene.frog_pos.x - 1);
            m_scene.bonus_pos.y = max(0, m_scene.frog_pos.y - 1);
            _PlaySound("gribit.wav");
            break;
         case '>':
         case '<':
         case '=':
            m_scene.stage = EATEN;
            break;
         case '^':
            m_GameState = 4;
            frog_anim = 0x94;
            m_HusPos[m_iHuseFuldt] = m_scene.frog_pos.x;
            m_iHuseFuldt++;
            m_iBonus += 100 + time_left;
            if( m_iHuseFuldt == m_scene.houses ) m_iBonus += 100;
            break;
         case '0':
         case '1':
         case '2':
         case '3':
         case '4':
         case '5':
         case '6':
         case '7':
         case '8':
         case '9':
         case '\xAE':
         case '\xAF':
         case '\xB0':
         case '\xB1':
         case '\xB2':
            break;
         default:
            m_scene.stage = SQUASHED;
            break;
      }
   }

   // Frog dies when out of bounds
   if( m_scene.frog_pos.x < 0 )
   {
      m_scene.frog_pos.x = 0;
      m_scene.stage = SQUASHED;
   }
   if( m_scene.frog_pos.x >= MAX_CHARS )
   {
      m_scene.frog_pos.x = MAX_CHARS - 1;
      m_scene.stage = SQUASHED;
   }

   // Timer reset
   if( oldstage != m_scene.stage || oldstate != m_GameState ) 
   {
      m_dwTickStage = ::GetTickCount();
   }

   // Play tune when game-state changes
   if( oldstage != m_scene.stage && oldstage == PLAYING )
   {
      if( m_scene.stage == SQUASHED ) _PlaySound("die.wav");
      if( m_scene.stage == DROWNING ) _PlaySound("die.wav");
      if( m_scene.stage == EATEN ) _PlaySound("die.wav");
   }
   if( oldstate != m_GameState )
   {
      if( m_GameState == 2 ) _PlaySound("gameover.wav");
      if( m_GameState == 4 ) _PlaySound("home.wav");
   }

   // Paint frog
   if( frog_anim != ' ' && m_scene.frog_pos.x >= 0 && m_scene.frog_pos.x < MAX_CHARS )
   {
      m_szLines[ m_scene.frog_pos.y ][ m_scene.frog_pos.x ] = frog_anim;
   }

   m_wKey = 0;
}

void CMainFrame::_GameOver()
{
   DWORD dwTick = ::GetTickCount();
   if( m_iScore > m_iHighScore ) m_iHighScore = m_iScore;
   _ClearScreen();
   sprintf(m_szLines[0], "     GAME OVER        ");
   sprintf(m_szLines[2], " YOUR SCORE: %ld      ", m_iScore);
   sprintf(m_szLines[3], " HIGHSCORE: %ld       ", m_iHighScore);
   if( dwTick - m_dwTickStage > 5000 || m_wKey != 0 ) {
      ::ZeroMemory(&m_scene, sizeof(m_scene));
      _PlaySound("start.wav");
      m_GameState = 0;
   }
   m_wKey = 0;
}

void CMainFrame::_YouDied()
{
   DWORD dwTick = ::GetTickCount();
   _ClearScreen();
   if( m_iLives <= 1 )
   {
      m_GameState = 2;
   }
   else
   {
      sprintf(m_szLines[1], "  YOU DIED         ");
      sprintf(m_szLines[3], "  LIVES LEFT: %s%s%s     ", 
         m_iLives > 1 ? "\x94" : "",
         m_iLives > 2 ? "\x94" : "",
         m_iLives > 3 ? "\x94" : "");
      if( dwTick - m_dwTickStage > 3000 ) {
         ::ZeroMemory(&m_scene, sizeof(m_scene));
         m_GameState = 1;
         m_iLives--;
      }
   }
   m_wKey = 0;
}

void CMainFrame::_StageComplete()
{
   DWORD dwTick = ::GetTickCount();
   _ClearScreen();
   sprintf(m_szLines[0], " WELL DONE          ");
   sprintf(m_szLines[2], " YOUR SCORE: %ld    ", m_iScore);
   if( m_iHuseFuldt >= m_scene.houses ) {
      sprintf(m_szLines[3], " NEXT STAGE: %ld     ", m_iStage + 1);
   }
   if( m_iBonus > 0 ) {
      int iStep = min(m_iBonus, 75);
      m_iScore += iStep;
      m_iBonus -= iStep;
      m_dwTickStage = ::GetTickCount();
   }
   if( m_iBonus == 0 && dwTick - m_dwTickStage > 3000 ) {
      if( m_iHuseFuldt >= m_scene.houses ) {
         m_iStage++;
         m_iHuseFuldt = 0;
      }
      ::ZeroMemory(&m_scene, sizeof(m_scene));
      m_GameState = 1;
   }
   m_wKey = 0;
}

void CMainFrame::_GameComplete()
{
   DWORD dwTick = ::GetTickCount();
   if( m_iScore > m_iHighScore ) m_iHighScore = m_iScore;
   _ClearScreen();
   sprintf(m_szLines[0], " ALL DONE !!      ");
   sprintf(m_szLines[2], " YOUR SCORE: %ld    ", m_iScore);
   sprintf(m_szLines[3], " HIGHSCORE: %ld     ", m_iHighScore);
   if( m_iBonus > 0 ) {
      int iStep = min(m_iBonus, 75);
      m_iScore += iStep;
      m_iBonus -= iStep;
      m_dwTickStage = ::GetTickCount();
   }
   if( m_iBonus == 0 && dwTick - m_dwTickStage > 5000 ) {
      ::ZeroMemory(&m_scene, sizeof(m_scene));
      _PlaySound("start.wav");
      m_GameState = 0;
   }
   m_wKey = 0;
}

void CMainFrame::_LoadScene()
{
   ::ZeroMemory(&m_scene, sizeof(m_scene));
   m_scene.frog_pos.x = MAX_CHARS - 1;
   m_scene.frog_pos.y = MAX_LINES - 1;
   CHAR szFileName[MAX_PATH];
   sprintf(szFileName, "%sscene%ld.txt", m_szPath, m_iStage);
   FILE* f = fopen(szFileName, "r");
   if( f == NULL ) {
      m_GameState = 5;
      return;
   }
   fgets(m_scene.title, sizeof(m_scene.title) - 1, f);
   fgets(m_scene.top, sizeof(m_scene.top) - 1, f);
   for( int i = 0; i < MAX_LINES - 1; i++ ) {
      m_scene.lines[i] = (LPSTR) malloc(1024);
      ::ZeroMemory(m_scene.lines[i], 1024);
      fgets(m_scene.lines[i], 1023, f);
   }
   int iIndex = 0;
   while( !feof(f) ) {
      CHAR szLine[200] = { 0 };
      fgets(szLine, sizeof(szLine) - 1, f);
      LPSTR p = strchr(szLine, ':');
      if( p == NULL ) continue;
      *p = '\0';
      LPSTR pstrValue = p + 1;
      while( isspace(*pstrValue) ) pstrValue++;
      if( stricmp(szLine, "LINE") == 0 ) iIndex = atoi(pstrValue) - 1;
      if( stricmp(szLine, "HOMES") == 0 ) m_scene.houses = atoi(pstrValue);
      if( stricmp(szLine, "TIME") == 0 ) m_scene.time = atoi(pstrValue);
      if( stricmp(szLine, "FROG-X") == 0 ) m_scene.frog_pos.x = atoi(pstrValue);
      if( stricmp(szLine, "FROG-Y") == 0 ) m_scene.frog_pos.y = atoi(pstrValue);
      if( stricmp(szLine, "SPEED") == 0 ) m_scene.info[iIndex].line_speed = atoi(pstrValue);
      if( stricmp(szLine, "CROC-EAT") == 0 ) m_scene.info[iIndex].croc_eat = atoi(pstrValue);
      if( stricmp(szLine, "CROC-DIVE") == 0 ) m_scene.info[iIndex].croc_dive = atoi(pstrValue);
      if( stricmp(szLine, "CROC-ABOVE") == 0 ) m_scene.info[iIndex].croc_above = atoi(pstrValue);
      if( stricmp(szLine, "FLY-APPEAR") == 0 ) m_scene.info[iIndex].fly_appear = atoi(pstrValue);
      if( stricmp(szLine, "FLY-BONUS") == 0 ) m_scene.fly_bonus = atoi(pstrValue);
   }
   fclose(f);

   SYSTEMTIME stNow;
   ::GetLocalTime(&stNow);

   m_scene.initialized = true;
   m_scene.stage = PLAYING;
   m_scene.dwRand = ::GetTickCount() + stNow.wSecond * stNow.wDay + ::GetMessagePos() + stNow.wMilliseconds + time(NULL);
   m_dwTickStart = m_dwTickStage = ::GetTickCount();   
}

void CMainFrame::_PlaySound(LPCSTR pstrWave)
{
   CHAR szFilename[MAX_PATH];
   sprintf(szFilename, "%s%s", m_szPath, pstrWave);
   ::PlaySound(szFilename, NULL, SND_FILENAME | SND_NODEFAULT | SND_ASYNC);
}

