#if !defined(AFX_FIXEDSTRING_H__836BD724_3F8A_11D2_87A7_0080AD509054__INCLUDED_)
#define AFX_FIXEDSTRING_H__836BD724_3F8A_11D2_87A7_0080AD509054__INCLUDED_

#pragma once


/////////////////////////////////////////////////////////////////////////////
// CFixedString - Fixed buffer String class
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//
// Description:
//   Implements a CString-like class with a fixed string-length buffer.
//   The buffer will be allocated on the stack and is size limited to 
//   the MAX_STR_LEN constant  which is initialized as the class is 
//   created as a template class.
//
//   Uses standard TCHAR.H string manipulation routines for most
//   operations.
//

template< int MAX_STR_LEN >
class CFixedString
{
public:
   // constructs empty CFixedString
   CFixedString()
   {
      Empty();
   }
   // from a single character
   CFixedString(TCHAR ch)
   {
      m_szBuffer[0] = ch;
      m_szBuffer[1] = _T('\0');
   }
   // from an ANSI string (converts to TCHAR)
   CFixedString(LPCTSTR lpsz)
   {      
      _ASSERTE(!::IsBadStringPtr(lpsz,-1));
      _ASSERTE(_tcslen(lpsz) <= MAX_STR_LEN);
      if( _tcslen(lpsz)<MAX_STR_LEN ) _tcscpy(m_szBuffer,lpsz); else Empty();
   }

   // Attributes

   TCHAR m_szBuffer[MAX_STR_LEN+1];  // Allocate string space + 0-char

   // Methods

   // get data length
   int GetLength() const { return _tcslen(m_szBuffer); };
   // TRUE if zero length
   BOOL IsEmpty() const { return m_szBuffer[0]==_T('\0'); };
   // clear contents to empty
   void Empty() { m_szBuffer[0]=_T('\0'); };
   // return single character at zero-based index
   TCHAR GetAt(int nIndex) const
   {
      _ASSERTE( nIndex>=0 && nIndex<=MAX_STR_LEN );
      return m_szBuffer[nIndex];
   }
   TCHAR operator[] (int nIndex) const 
   { 
      _ASSERTE( nIndex>=0 && nIndex<=MAX_STR_LEN );
      return m_szBuffer[nIndex];
   }
   // set a single character at zero-based index
   void SetAt(int nIndex, TCHAR ch)
   {
      _ASSERTE( nIndex>=0 && nIndex<=MAX_STR_LEN );
      m_szBuffer[nIndex] = ch;
   }
   // return pointer to const string
   operator LPCTSTR() const { return m_szBuffer; };

   // Overloaded assignment

   // set string content to single character
   const CFixedString& operator=(TCHAR ch)
   {
      m_szBuffer[0] = ch;
      m_szBuffer[1] = _T('\0');
      return *this;
   }
   // copy string content from ANSI string (converts to TCHAR)
   const CFixedString& operator=(LPCSTR lpsz)
   {      
      _ASSERTE(!::IsBadStringPtr(lpsz,-1));
      if( _tcslen(lpsz)<=MAX_STR_LEN ) _tcscpy(m_szBuffer,lpsz); else Empty();
      return *this;
   }

   // String concatenation

   // concatenate a single character
   const CFixedString& operator+=(TCHAR ch)
   {      
      if( GetLength() <= MAX_STR_LEN-1 ) {
         TCHAR szTmp[2] = {ch,0};
         _tcscat(m_szBuffer,szTmp);
      }
      return *this;
   }
   // concatenate a UNICODE character after converting it to TCHAR
   CFixedString operator+(LPCSTR str)
   {
      _ASSERTE(!::IsBadStringPtr(lpsz,-1));
      if( _tcslen(m_szBuffer) + _tcslen(str) <= MAX_STRING_LEN ) _tcscat( m_szBuffer, str1 );
   }
   const CFixedString& operator+=(LPCTSTR lpsz)
   {      
      _ASSERTE(!::IsBadStringPtr(lpsz,-1));
      if( GetLength() + _tcslen(lpsz) <= MAX_STR_LEN ) _tcscat(m_szBuffer,lpsz);
      return *this;
   }

   // string comparison
   BOOL operator == (LPCSTR str) const { return (Compare(str) == 0); };
   BOOL operator != (LPCSTR str) const { return (Compare(str) != 0); };
   BOOL operator <= (LPCSTR str) const { return (Compare(str) <= 0); };
   BOOL operator <  (LPCSTR str) const { return (Compare(str) <  0); };
   BOOL operator >= (LPCSTR str) const { return (Compare(str) >= 0); };
   BOOL operator >  (LPCSTR str) const { return (Compare(str) >  0); };

   // straight character comparison
   int Compare(LPCTSTR lpsz) const { return _tcscmp(m_szBuffer,lpsz); };
   // compare ignoring case
   int CompareNoCase(LPCTSTR lpsz) const { return _tcsicmp(m_szBuffer,lpsz); };
   
   // Upper/lower/reverse conversion

   // NLS aware conversion to uppercase
   void MakeUpper() { _tcsupr(m_szBuffer); };
   // NLS aware conversion to lowercase
   void MakeLower() { _tcslwr(m_szBuffer); };

   // String manipulation

   CFixedString Left(int len) 
   {
      CFixedString<MAX_STR_LEN> dest;
      if( len>GetLength() ) len = GetLength();
      _tcsncpy( dest.m_szBuffer, m_szBuffer, len );
      dest.m_szBuffer[len] = _T('\0');
      return dest;
   }
   CFixedString Mid(int pos,int len=-1) 
   {
      CFixedString<MAX_STR_LEN> dest;
      if( len<0 ) len = GetLength()-pos;
      if( pos+len>GetLength() ) len = GetLength() - pos;
      if( len<=0 ) return dest;
      _tcsncpy( dest.m_szBuffer, &m_szBuffer[pos], len );
      dest.m_szBuffer[len] = _T('\0');
      return dest;
   }
   CFixedString Right(int len) 
   {
      CFixedString<MAX_STR_LEN> dest;
      int pos = GetLength()-len;
      if( pos<0 ) {
         pos = 0;
         len = GetLength();
      }
      _tcsncpy( dest.m_szBuffer, &m_szBuffer[pos], len );
      dest.m_szBuffer[len] = _T('\0');
      return dest;
   }

   // Searching

   // find character starting at left, -1 if not found
   int Find(TCHAR ch) const
   {
      LPCTSTR p = _tcschr(m_szBuffer, ch);
      if(p==NULL) return -1;
      return p - m_szBuffer;
   }
   // find character starting at right
   int ReverseFind(TCHAR ch) const
   {
      LPCTSTR p = _tcsrchr(m_szBuffer, ch);
      if(p==NULL) return -1;
      return p - m_szBuffer;
   }
   // find first instance of substring
   int Find(LPCTSTR lpszSub) const
   {
      _ASSERTE(!::IsBadStringPtr(lpszSub,-1));
      LPCTSTR p = _tcsstr(m_szBuffer, lpszSub);
      if(p==NULL) return -1;
      return p - m_szBuffer;
   }

};

#endif // !defined(AFX_FIXEDSTRING_H__836BD724_3F8A_11D2_87A7_0080AD509054__INCLUDED_)
