
#include "stdafx.h"
#include "System.h"
#include "Utils.h"
#include <stdio.h>


//////////////////////////////////////
//

HRESULT CSystem::CreateWorld_Actor(MSXML::IXMLDOMNodePtr &spNode, CActorNode *pNode)
{
   USES_CONVERSION;
   MSXML::IXMLDOMNodeListPtr spList;
   spList = spNode->selectNodes(_bstr_t(L"bones/bone"));
   for( int i=0; i<spList->length; i++ ) {
      MSXML::IXMLDOMNodePtr spNode = spList->item[i];
      MSXML::IXMLDOMNamedNodeMapPtr spAttribs = spNode->attributes;
      MSXML::IXMLDOMAttributePtr spAttrib;
      _variant_t vValue;
      _bstr_t sName;
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("id"));
      sName = vValue = spAttrib->value;
      DWORD dwID = _wtol(sName);
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("parent"));
      sName = vValue = spAttrib->value;
      DWORD dwParent = _wtol(sName);
      //
      CHAR szName[64];
      strcpy( szName, OLE2A(spNode->text));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("size"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 size = ParseVector3(OLE2T(sName));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("pivot"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 pivot = ParseVector3(OLE2T(sName));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("rot"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 rot = ParseVector3(OLE2T(sName));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("minrot"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 min_rot = ParseVector3(OLE2T(sName));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("maxrot"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 max_rot = ParseVector3(OLE2T(sName));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("scale"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 scale = ParseVector3(OLE2T(sName));
      //
      spAttrib = spAttribs->getNamedItem(_bstr_t("trans"));
      sName = vValue = spAttrib->value;
      D3DXVECTOR3 trans = ParseVector3(OLE2T(sName));
      //
      pNode->AddBone(dwID, dwParent, szName, size, pivot, trans, scale, rot, min_rot, max_rot);
   }
   return S_OK;
};

HRESULT CSystem::CreateWorld_View(MSXML::IXMLDOMNodePtr &spNode)
{
   USES_CONVERSION;
   MSXML::IXMLDOMNodeListPtr spNodes = spNode->childNodes;
   for( int i=0; i<spNodes->length; i++ ) {
      MSXML::IXMLDOMNodePtr spNode = spNodes->item[i];
      _bstr_t sName = spNode->nodeName;
      _bstr_t sValue = spNode->text;
      LPCTSTR pstrName = OLE2T(sName);
      LPCTSTR pstrValue = OLE2T(sValue);
      if( sName==_bstr_t(L"background-color") ) {
         _Engine.m_colorClear = ParseColor4(pstrValue);
      };
   };
   return S_OK;
}

HRESULT CSystem::CreateWorld_Node(MSXML::IXMLDOMNodePtr &spNode, CNode **pNode)
{
   if( spNode==NULL ) return E_POINTER;
   USES_CONVERSION;
   HRESULT Hr = S_OK;

   MSXML::IXMLDOMNamedNodeMapPtr spAttribs = spNode->attributes;
   MSXML::IXMLDOMAttributePtr spAttrib = spAttribs->getNamedItem(_bstr_t("class"));
   _variant_t vValue = spAttrib->value;
   _bstr_t sName = vValue;

   LogText("  Creating class %ls.", (BSTR)sName);
   *pNode = NULL;

   // May be a dynamically loaded plug-in...
   // Format is "libraryname.classname", where the dot is significant
   // for the two types of nodes.
   if( wcsrchr(sName, L'.')!=0 ) {
      LPSTR str = OLE2A(sName);
      LPSTR p = strrchr(str, L'.');
      sName = p+1;
      if( sName.length()<3 ) return E_INVALIDARG; // Eh, need to be at least 3 chars
      strcpy(p, "DLL");
      HINSTANCE hInst = ::LoadLibrary(str);
      // TODO: Finish dynamically loading of plug-ins
   }
   else {
      if( sName==_bstr_t("Ground") ) *pNode = new CGround;
      if( sName==_bstr_t("Background") ) *pNode = new CBackground;
      if( sName==_bstr_t("Player") ) *pNode = new CPlayer;
      if( sName==_bstr_t("MD2") ) *pNode = new CMD2;
      if( sName==_bstr_t("3DS") ) *pNode = new C3DS;
      if( sName==_bstr_t("Actor") ) *pNode = new CActor;
      if( sName==_bstr_t("Light") ) *pNode = new CLight;
   }
   if( *pNode==NULL ) {
      LogError("Unable to load node. Not a recognized class.");
      return E_FAIL;
   }
   // Initialize right away...
   Hr = (*pNode)->Initialize(this, &_Engine);
   if( FAILED(Hr) ) {
      LogError("Unable to initialize node.");
      return Hr;
   }

   // Read node properties and set them
   MSXML::IXMLDOMNodeListPtr spNodes = spNode->childNodes;
   for( int i=0; i<spNodes->length; i++ ) {
      MSXML::IXMLDOMNodePtr spNode = spNodes->item[i];
      _bstr_t sName = spNode->nodeName;
      _bstr_t sValue = spNode->text;
      LPCSTR pstrName = OLE2A(sName);
      LPCSTR pstrValue = OLE2A(sValue);
      Hr = (*pNode)->SetProperty(pstrName, pstrValue);
      if( FAILED(Hr) ) {
         LogError("Unable to set property '%s'", pstrName);
         return Hr;
      };
   }

   NODETYPE Type;
   (*pNode)->GetType(Type);
   switch( Type ) {
   case NODE_ACTOR:
      Hr = CreateWorld_Actor(spNode, static_cast<CActorNode*>(*pNode));
      break;
   };
   if( FAILED(Hr) ) {
      LogError("Unable to create Node properties.");
      return Hr;
   };

   return S_OK;
}


//////////////////////////////////////
//

HRESULT CSystem::CreateWorld()
{
   LogText("Creating world:");

   m_nNodes = 0;
   
   ::CoInitialize(NULL);
   try
   {
      MSXML::IXMLDOMDocumentPtr spXML(__uuidof(MSXML::DOMDocument));
#ifdef _DEBUG
      spXML->validateOnParse = VARIANT_TRUE;
#else
      spXML->validateOnParse = VARIANT_FALSE;
#endif
      spXML->async = VARIANT_FALSE;
      VARIANT_BOOL bOk = spXML->load(L"world.xml");
      if( bOk==VARIANT_FALSE ) {
         MSXML::IXMLDOMParseErrorPtr spError = spXML->parseError;
         LogError("Error in line: %d: %ls", spError->line, spError->reason);
         return E_FAIL;
      };
      MSXML::IXMLDOMNodePtr spRoot = spXML->documentElement;
      MSXML::IXMLDOMNodeListPtr spList;
      MSXML::IXMLDOMNodePtr spNode;
      int i;

      // View settings
      spNode = spXML->selectSingleNode(_bstr_t(L"world/system/view"));
      if( spNode!=NULL ) {
         CreateWorld_View(spNode);
      }
      
      // Nodes
      spList = spXML->selectNodes(_bstr_t(L"world/nodes/node"));
      for( i=0; i<spList->length; i++ ) {
         MSXML::IXMLDOMNodePtr spNode = spList->item[i];
         CNode *pNode;
         HRESULT Hr = CreateWorld_Node(spNode, &pNode);
         if( !FAILED(Hr) ) {
            m_ppNodes[ m_nNodes++ ] = static_cast<CSurfaceNode *>(pNode);
         }
      };

      // Lights
      spList = spXML->selectNodes(_bstr_t(L"world/lights/light"));
      for( i=0; i<spList->length; i++ ) {
         MSXML::IXMLDOMNodePtr spNode = spList->item[i];
         CNode *pNode;
         HRESULT Hr = CreateWorld_Node(spNode, &pNode);
         if( !FAILED(Hr) ) {
            CHAR szID[8];
            ltoa(m_nLights,szID,10);
            pNode->SetProperty("ID", szID);
            m_ppLights[ m_nLights++ ] = pNode;
         }
      };

      // Spectators
      spList = spXML->selectNodes(_bstr_t(L"world/spectators/node"));
      for( i=0; i<spList->length; i++ ) {
         MSXML::IXMLDOMNodePtr spNode = spList->item[i];
         CNode *pNode;
         HRESULT Hr = CreateWorld_Node(spNode, &pNode);
         if( !FAILED(Hr) ) {
            m_ppSpectators[ m_nSpectators++ ] = static_cast<CSpectatorNode *>(pNode);
         }
      };
   }
   catch( _com_error e )
   {
      LogError(e.Error());
      return e.Error();
   };
   ::CoUninitialize();   

   LogText("World created.");
   return S_OK;
};

HRESULT CSystem::PrepareWorld()
{
   LogText("Initializing world...");
   HRESULT Hr;
   int i;
#define CREATE(x) \
  for( i=0; i<m_n##x; i++ ) { \
     Hr = m_pp##x[i]->Create(); \
     if( FAILED(Hr) ) { \
        LogError("Node "#x" creation failed."); \
     }; \
  }
   CREATE(Nodes);
   CREATE(Lights);
   CREATE(Spectators);
#undef CREATE
   // Also create surfaces for Surface Nodes
   for( i=0; i<m_nNodes; i++ ) {
      Hr = m_ppNodes[i]->CreateSurfaces();
      if( FAILED(Hr) ) {
         LogError("Node surface creation failed.");
      };
   }
   LogText("World initialized.");
   return S_OK;
};

HRESULT CSystem::CloseWorld()
{
   int i;
#define DONE(x) \
  for( i=0; i<m_n##x; i++ ) m_pp##x[i]->Done(); \
  for( i=0; i<m_n##x; i++ ) delete m_pp##x[i]; \
  m_n##x = 0;
   DONE(Nodes);
   DONE(Lights);
   DONE(Spectators);
#undef DONE
   LogText("World destroyed.");
   return S_OK;
};