
#pragma once

#include "Node.h"

#define NUM_NODES 64
#define NUM_LIGHTS 16
#define NUM_SPECTATORS 32

class CSystem
{
public:
   CSystem()
   {
      m_hCursor = NULL;
      m_bFullScreen = false;
      //
      m_bActive = false;
      //
      ZeroMemory(m_bKey, sizeof(m_bKey));
      m_keyPress = 0;
      //
      m_bMouseCaptured = false;
      m_wMouseButtons = 0;
      m_nLastMouseX = 0;
      m_nLastMouseY = 0;
      //
      m_nNodes = 0;
      m_nLights = 0;
      m_nSpectators = 0;
   };

   ~CSystem()
   {
   }

public:
   HINSTANCE m_hAppInstance;
   HWND m_hwnd;
   //
   bool m_bFullScreen;
   bool m_bActive;
   //
   bool m_bKey[256];
   BYTE m_keyPress;
   //
   bool m_bMouseCaptured;
   WORD m_wMouseButtons;
   int m_nLastMouseX;
   int m_nLastMouseY;
   //   
   HCURSOR m_hCursor;
   //
   CFile m_fileLog;
   char m_szAppPath[MAX_PATH];
   char m_szResPath[MAX_PATH];
   char m_szAppName[64];
   //
   CSurfaceNode *m_ppNodes[NUM_NODES];
   short m_nNodes;
   CNode *m_ppLights[NUM_LIGHTS];
   short m_nLights;
   CSpectatorNode *m_ppSpectators[NUM_SPECTATORS];
   short m_nSpectators;

public:
   HRESULT Init(HINSTANCE hInst, LPCSTR szCmdLine);
   HRESULT Close();
   HRESULT GameLoop();
   //
   HRESULT CreateWorld();
   HRESULT PrepareWorld();
   //
   void _cdecl LogText(LPCSTR str, ...);
   void _cdecl LogError(LPCSTR str, ...);
   HRESULT LogError(HRESULT Hr);
   //
   HRESULT DisplayConsole();
   HRESULT HideConsole();
   void ConsolePrint(LPCSTR str);
protected:
   HRESULT ParseCommandLine(LPCSTR pstrCmdLine);
   HRESULT CreateGameWindow();
   HRESULT CloseGameWindow();
   HRESULT ShowGameWindow();
   //
   HRESULT CreateConsole();
   HRESULT CloseConsole();
   //
   HRESULT CreateWorld_Node(MSXML::IXMLDOMNodePtr &spNode, CNode **pNode);
   HRESULT CreateWorld_View(MSXML::IXMLDOMNodePtr &spNode);
   HRESULT CreateWorld_Actor(MSXML::IXMLDOMNodePtr &spNode, CActorNode *pNode);
   HRESULT CloseWorld();

};

