
#include "stdafx.h"
#include "MD2.h"

//////////////////////////////////////////////////////////////////////////////
//
// CMD2 
//

CMD2::CMD2()
{
   ZeroMemory(&m_model,sizeof(m_model));
   ZeroMemory(src_v,sizeof(src_v));
   m_szModelFilename[0] = '\0';
   m_szSkinFilename[0] = '\0';
   m_cull = true;
   m_scale = 0.3f;
}

CMD2::~CMD2()
{
}

HRESULT CMD2::Initialize(CSystem *, CEngine *)
{
   return S_OK;
}

HRESULT CMD2::SetProperty(LPCSTR szItem, LPCSTR szValue)
{
   if( stricmp(szItem,"FILENAME")==0 ) {
      strcpy( m_szModelFilename, szValue );
      return S_OK;
   }
   if( stricmp(szItem,"SKIN")==0 ) {
      strcpy( m_szSkinFilename, szValue );
      return S_OK;
   }
   if( stricmp(szItem,"SCALE")==0 ) {
      m_scale = (float)atof(szValue);
      return S_OK;
   };
   if( stricmp(szItem,"CULL")==0 ) {
      m_cull = (_toupper(szValue[0])=='Y');
      return S_OK;
   };
   return E_INVALIDARG;
}

HRESULT CMD2::Create()
{
   CHAR szFilename[MAX_PATH];

   strcpy( szFilename, _System.m_szResPath );
   strcat( szFilename, m_szSkinFilename );
   CPCX pcx;
   LPDIRECTDRAWSURFACE7 pSurface;
   HRESULT Hr = pcx.CreateSurface(szFilename, &pSurface);
   if( FAILED(Hr) ) return Hr;
   _Engine.CreateTexture(pSurface,m_iTexture);

   CFile f;
   strcpy( szFilename, _System.m_szResPath );
   strcat( szFilename, m_szModelFilename );
   if( f.Open(szFilename)==FALSE ) return E_FAIL;

   MD2HEADER header;
   f.Read(&header, sizeof(header) );   
   // Is it a Quake model?
   if( header.ident!=0x32504449 ) return E_NOINTERFACE;
   // If there are no GL commands here, quit.
   if( header.offset_end==header.offset_glcmds ) return E_UNEXPECTED;

   long id = 1;
   long num_glcmds = 0;
   long num_indices = 0;

   // Move file pointer to the start of the GL command list
   f.Seek((UINT)header.offset_glcmds, FILE_BEGIN);

   while( id != 0 ) {   
      // Read in primitive commands from md2 file
      f.Read(&id,sizeof(int));
      // id = 0 indicates the end of the command list
      if(id != 0)   {
         long num_indices_per_primitive;   
         num_indices_per_primitive = abs(id);
         long findex;
         for(findex = 0; findex < num_indices_per_primitive; findex++) {
            float fs, ft;
            long N;
            f.Read(&fs,sizeof(float));
            f.Read(&ft,sizeof(float));
            f.Read(&N,sizeof(int));
            num_indices++;
         } ;
         num_glcmds++;
      };
   };

   // LOAD FACE AND TEXTURE CO_ORDINATES
   
   // The GL command format:
   // A positive integer for the "id" variable starts a tristrip command, 
   // followed by that many vertex structures.
   // A negative integer for "id" starts a trifan command, followed 
   // by -x vertexes a zero indicates the end of the command list.
   // A vertex consists of a floating polong s, a floating polong t,
   // and an integer vertex index.

   // Move file pointer to the start of the GL command list
   f.Seek((UINT)header.offset_glcmds, FILE_BEGIN);
   
   m_model.NumPrimitives = num_glcmds;
   m_model.Primitives = new MD2OBJECT[num_glcmds];

   id = 1;
   num_indices = 0;
   long prim_cnt = 0;

   while( id != 0 ) {
      // Read in primitive commands from md2 file
      f.Read(&id,sizeof(int));      
      // id = 0 indicates the end of the command list
      if(id != 0) {
         long num_indices_per_primitive;   
         num_indices_per_primitive = abs(id);
         if(id < 0 )   
            m_model.Primitives[prim_cnt].PrimitiveType = MD2_TRIANGLEFAN;
         if(id > 0 )   
            m_model.Primitives[prim_cnt].PrimitiveType = MD2_TRIANGLESTRIP;      

         m_model.Primitives[prim_cnt].FaceIndices = new MD2FACEINDEX[num_indices_per_primitive];
         m_model.Primitives[prim_cnt].NumFaceIndices = num_indices_per_primitive;

         long findex;
         for(findex = 0; findex < num_indices_per_primitive; findex++) {
            float fs, ft;
            long N;
            // Read texture co-ordinates s and t
            f.Read(&fs,sizeof(float));
            m_model.Primitives[prim_cnt].FaceIndices[findex].s = fs;
            f.Read(&ft,sizeof(float));
            m_model.Primitives[prim_cnt].FaceIndices[findex].t = ft;
            // Read face index
            f.Read(&N,sizeof(int));
            m_model.Primitives[prim_cnt].FaceIndices[findex].index = N;
            //
            num_indices++;
         }      
         prim_cnt++;      
      }
   }
   m_model.NumIndices = num_indices;

   // LOAD VERTS FOR EACH FRAME OF ANIMATION

   m_model.Frames = new MD2FRAME[header.num_frames];
   m_model.NumFrames = header.num_frames;

   m_model.NumVerts = header.num_verts;

   // Read vertices for all frames
   f.Seek((UINT)header.offset_frames, FILE_BEGIN);

   long frame_num;
   for(frame_num = 0; frame_num < header.num_frames; frame_num++) {
      float bscale[3];      
      float translate[3]; 
      f.Read(bscale,sizeof(float)*3);
      f.Read(translate,sizeof(float)*3);
      CHAR name[20];
      f.Read(name,16);   
      strcpy(m_model.Frames[frame_num].framename, name );
   
      m_model.Frames[frame_num].Verts = new MD2VERT[header.num_verts];
      long v;
      for(v = 0; v < header.num_verts; v++) { // VERTS
         MD2BYTE_VERTEX bverts;
         f.Read(&bverts,sizeof(MD2BYTE_VERTEX)); 
         m_model.Frames[frame_num].Verts[v].x = m_scale * (bscale[0] * bverts.v[0] + translate[0]);
         m_model.Frames[frame_num].Verts[v].y = m_scale * (bscale[1] * bverts.v[1] + translate[1]);
         m_model.Frames[frame_num].Verts[v].z = m_scale * (bscale[2] * bverts.v[2] + translate[2]);
      }
   }

   f.Close();

   return S_OK;
}

HRESULT CMD2::Done()
{
   for(long i=0; i<m_model.NumPrimitives; i++ ) {
      DELETE_ARRAY(m_model.Primitives[i].FaceIndices);
   }
   DELETE_ARRAY(m_model.Primitives);
   DELETE_ARRAY(m_model.Frames);
   return S_OK;
}

HRESULT CMD2::CreateSurfaces()
{
    return S_OK;
}

HRESULT CMD2::RestoreSurfaces()
{
   HRESULT Hr;
   if( FAILED( Hr = ReleaseSurfaces() ) ) return Hr;
   if( FAILED( Hr = CreateSurfaces() ) ) return Hr;
   return S_OK;
}

HRESULT CMD2::ReleaseSurfaces()
{
   return S_OK;
}

HRESULT CMD2::Draw()
{
   long frame_num = m_model.CurrentFrame;
   static long t=0;
   if( (t++ & 3)==0 ) m_model.CurrentFrame++;
   if( m_model.CurrentFrame>=m_model.NumFrames ) m_model.CurrentFrame = 0;

   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, m_cull ? D3DCULL_CW : D3DCULL_NONE );
   _Engine.m_pD3DDevice->SetTexture(0, _Engine.m_ppTextures[m_iTexture]);
   D3DPRIMITIVETYPE D3dPrimType;
   
   // FACE INDICES AND TEXTURE CO_ORDINATES
   // These are dealt with one polygon at a time.
   // Each poly has an associated number of indices and 
   // texture co-ordinates.

   // Go through the list of polys one by one and render then
   for(long prim_cnt = 0; prim_cnt < m_model.NumPrimitives; prim_cnt++) {
      // Get the number of indices (indexes) for this poly
      long num_indices = m_model.Primitives[prim_cnt].NumFaceIndices;
      // Number of texture co-ordinates is the same as the number of indices
      long num_tex_indices = num_indices;

      // Get the Id value for the current prim
      long PrimitiveType = m_model.Primitives[prim_cnt].PrimitiveType;
      // Is the current poly a TRIANGLEFAN (list of triangles in a circle 
      // that share a commom vert in the centre of the circle).      
      if( PrimitiveType == MD2_TRIANGLEFAN) D3dPrimType = D3DPT_TRIANGLEFAN;
      // Is the current poly a TRIANGLESTRIP (list of triangles usually in a strip
      // or box shape that are connected together and share common two verts
      // along the joining line beween triangles.
      // Triangle strips are composed of at least two triangle or more.
      // You need three vertices to define the first trianlge in the strip
      // then a further one vertex per additional triangle.
      if( PrimitiveType == MD2_TRIANGLESTRIP)  D3dPrimType = D3DPT_TRIANGLESTRIP;

      // Go through all the indices, and texture co-ordinates for this poly
      float wx=0.0f, wy=8.2f, wz=0.0f;

      for(long index_cnt = 0; index_cnt < num_indices; index_cnt++) {
         long index = m_model.Primitives[prim_cnt].FaceIndices[index_cnt].index;

         float tex_coord_s = m_model.Primitives[prim_cnt].FaceIndices[index_cnt].s;
         float tex_coord_t = m_model.Primitives[prim_cnt].FaceIndices[index_cnt].t;

         // Note : swap Y and Z co-ordinates because MD2 models have 
         // the Z axis as the up axis, and we use the Y axis as up in this sample.
         float x,y,z;
         x = m_model.Frames[frame_num].Verts[index].x;
         z = m_model.Frames[frame_num].Verts[index].y;
         y = m_model.Frames[frame_num].Verts[index].z;

         src_v[index_cnt].x  = wx + x; 
         src_v[index_cnt].y  = wy + y;
         src_v[index_cnt].z  = wz + z;
         src_v[index_cnt].tu = tex_coord_s;
         src_v[index_cnt].tv = tex_coord_t;
      }

      if( _Engine.m_pD3DDevice->DrawPrimitive(D3dPrimType, 
                              D3DFVF_VERTEX, 
                              (LPVOID)&src_v, 
                              (DWORD)num_indices, 
                              NULL ) != D3D_OK ) 
      {
         return E_FAIL;
      }
   }
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CCW);
   return S_OK;
}
