
#include "stdafx.h"
#include "Ground.h"

//////////////////////////////////////////////////////////////////////////////
//
// CGround 
//

#pragma pack(4)
typedef struct GROUND_VERTEX
{
    D3DXVECTOR3 m_vecPos;
    D3DCOLOR    m_dwDiffuse;
    D3DXVECTOR2 m_vecTex;
} GROUND_VERTEX;


CGround::CGround()
{
   m_uIndices  = 0;
   m_uVertices = 0;
   m_pwIndices   = NULL;
   m_pvbVertices = NULL;
}

CGround::~CGround()
{
   DELETE(m_pwIndices);
   RELEASE(m_pvbVertices);
}

HRESULT CGround::Initialize(CSystem *, CEngine *)
{
   m_fWidth  = 256.0f;
   m_fHeight = 256.0f;
   m_fTile   = 10.0f;
   m_dwColor = D3DXCOLOR(0.17f, 0.35f, 0.7f, 0.75f);
   m_szTextureFilename[0] = '\0';
   return S_OK;
}

HRESULT CGround::SetProperty(LPCSTR szItem, LPCSTR szValue)
{
   if( stricmp(szItem,"WIDTH")==0 ) m_fWidth = (float)atof(szValue);
   else if( stricmp(szItem,"HEIGHT")==0 ) m_fHeight = (float)atof(szValue);
   else if( stricmp(szItem,"TILE")==0 ) m_fTile = (float)atof(szValue);
   else if( stricmp(szItem,"COLOR")==0 ) m_dwColor = (DWORD)atol(szValue);
   else if( stricmp(szItem,"TEXTURE")==0 ) strcpy(m_szTextureFilename, szValue);
   else return E_INVALIDARG;
   return S_OK;
}

HRESULT CGround::GetProperty(LPCSTR szItem, LPSTR szValue, short nLength)
{
   return E_NOTIMPL;
}

HRESULT CGround::Create()
{
   if( m_szTextureFilename[0]=='\0' ) return E_INVALIDARG;
   _Engine.CreateTexture(m_szTextureFilename, m_iTexture);

   // Calculate number of vertices and indices
   UINT uDivs = 8;

   m_uVertices = (uDivs + 1) * (uDivs + 1);
   m_uIndices  = (uDivs * uDivs) * 6;

   // Create indices
   m_pwIndices = new WORD[m_uIndices];
   if(m_pwIndices==NULL) return E_OUTOFMEMORY;

   // Fill in indicies
   WORD *pwIndex = m_pwIndices;
   for(UINT uZ = 0; uZ < uDivs; uZ++) {
      for(UINT uX = 0; uX < uDivs; uX++) {
         UINT uVertex = uX + uZ * (uDivs + 1);
         pwIndex[0] = uVertex + 0;
         pwIndex[1] = uVertex + 1;
         pwIndex[2] = uVertex + (uDivs + 1);
         pwIndex[3] = uVertex + (uDivs + 1);
         pwIndex[4] = uVertex + 1;
         pwIndex[5] = uVertex + (uDivs + 2);
         pwIndex += 6;
         uVertex++;
      }
   }

   return S_OK;
}

HRESULT CGround::Done()
{
   return S_OK;
}

HRESULT CGround::CreateSurfaces()
{
    HRESULT hr;

    if(m_pvbVertices==NULL) {
        // Create vertices      
        D3DVERTEXBUFFERDESC vbdesc;
        vbdesc.dwSize = sizeof(vbdesc);
        vbdesc.dwCaps = 0;
        vbdesc.dwFVF = D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0);
        vbdesc.dwNumVertices = m_uVertices;

        if( !(_Engine.m_D3DDeviceDesc.dwDevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) ||
            IsEqualGUID(_Engine.m_D3DDeviceDesc.deviceGUID, IID_IDirect3DRefDevice) ) {
            vbdesc.dwCaps |= D3DVBCAPS_SYSTEMMEMORY;
        }
    
        GROUND_VERTEX *pVertices;
        if( FAILED(hr = _Engine.m_pD3D->CreateVertexBuffer(&vbdesc, &m_pvbVertices, 0)) )
            return hr;

        if( SUCCEEDED(m_pvbVertices->Lock(DDLOCK_WAIT | DDLOCK_WRITEONLY, (void **) &pVertices, NULL)) ) {
            // Fill in vertices
            UINT uDivs = 8;
            UINT uX, uZ;

            float fXInc = m_fWidth  / (float) uDivs;
            float fZInc = m_fHeight / (float) uDivs;

            float fSInc = m_fTile / (float) uDivs;
            float fTInc = m_fTile / (float) uDivs;

            float fZ = m_fHeight * -0.5f;
            float fT = 0.0f;

            for(uZ = 0; uZ <= uDivs; uZ++) {
                float fX = m_fWidth  * -0.5f;
                float fS = 0.0f;

                for(uX = 0; uX <= uDivs; uX++) {
                    GROUND_VERTEX *pVertex;
                    pVertex = &pVertices[uX + uZ * (uDivs + 1)];
                    pVertex->m_vecPos = D3DXVECTOR3(fX, 0.0f, fZ);
                    pVertex->m_dwDiffuse = m_dwColor;
                    pVertex->m_vecTex = D3DXVECTOR2(fS, fT);

                    fX += fXInc;
                    fS += fSInc;
                }

                fZ += fZInc;
                fT += fTInc;
            }

            m_pvbVertices->Unlock();
            m_pvbVertices->Optimize(_Engine.m_pD3DDevice, 0);
        }
    }

    return S_OK;
}

HRESULT CGround::RestoreSurfaces()
{
   HRESULT Hr;
   if( FAILED( Hr = ReleaseSurfaces() ) ) return Hr;
   if( FAILED( Hr = CreateSurfaces() ) ) return Hr;
   return S_OK;
}

HRESULT CGround::ReleaseSurfaces()
{
   RELEASE(m_pvbVertices);
   return S_OK;
}

HRESULT CGround::Draw()
{
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_LIGHTING, FALSE);
   _Engine.m_pD3DDevice->SetTexture(0, _Engine.m_ppTextures[m_iTexture]);
   _Engine.m_pD3DDevice->DrawIndexedPrimitiveVB(D3DPT_TRIANGLELIST, m_pvbVertices, 0, m_uVertices, m_pwIndices, m_uIndices, D3DDP_WAIT);
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_LIGHTING, TRUE);
   return S_OK;
}
