
#include "stdafx.h"
#include "Background.h"

//////////////////////////////////////////////////////////////////////////////
//
// CBackground 
//

CBackground::CBackground()
{
}

CBackground::~CBackground()
{
}

HRESULT CBackground::Initialize(CSystem *, CEngine *)
{
   m_fWidth  = 1.0f;
   m_fHeight = 1.0f;
   m_fDepth = 0.5f;
   m_szTextureFilename[0] = '\0';
   return S_OK;
}

HRESULT CBackground::SetProperty(LPCSTR szItem, LPCSTR szValue)
{
   if( stricmp(szItem,"WIDTH")==0 ) m_fWidth = (float)atof(szValue);
   else if( stricmp(szItem,"HEIGHT")==0 ) m_fHeight = (float)atof(szValue);
   else if( stricmp(szItem,"Z")==0 ) m_fDepth = (float)atof(szValue);
   else if( stricmp(szItem,"TEXTURE")==0 ) strcpy(m_szTextureFilename, szValue);
   else return E_INVALIDARG;
   return S_OK;
}

HRESULT CBackground::GetProperty(LPCSTR szItem, LPSTR szValue, short nLength)
{
   return E_NOTIMPL;
}

HRESULT CBackground::Create()
{
   if( m_szTextureFilename[0]=='\0' ) return E_INVALIDARG;
   _Engine.CreateTexture(m_szTextureFilename, m_iTexture);

   D3DVECTOR vFar = D3DVECTOR( 0.0f, 0.0f, m_fDepth );
   m_Background[0] = D3DTLVERTEX( vFar, 0.5f, 0xffffffff, 0, 0.0f, 1.0f );
   m_Background[1] = D3DTLVERTEX( vFar, 0.5f, 0xffffffff, 0, 0.0f, 0.0f );
   m_Background[2] = D3DTLVERTEX( vFar, 0.5f, 0xffffffff, 0, 1.0f, 1.0f );
   m_Background[3] = D3DTLVERTEX( vFar, 0.5f, 0xffffffff, 0, 1.0f, 0.0f );
   return S_OK;
}

HRESULT CBackground::Done()
{
   return S_OK;
}

HRESULT CBackground::CreateSurfaces()
{
   HRESULT Hr;
   // Set up the dimensions for the background image
   D3DVIEWPORT7 vp;
   Hr = _Engine.m_pD3DDevice->GetViewport(&vp);
   if( FAILED(Hr) ) return Hr;
   m_Background[0].sy = (FLOAT)vp.dwHeight * m_fHeight;
   m_Background[2].sy = (FLOAT)vp.dwHeight * m_fHeight;
   m_Background[2].sx = (FLOAT)vp.dwWidth * m_fWidth;
   m_Background[3].sx = (FLOAT)vp.dwWidth * m_fWidth;

   return S_OK;
}

HRESULT CBackground::RestoreSurfaces()
{
   HRESULT Hr;
   if( FAILED( Hr = ReleaseSurfaces() ) ) return Hr;
   if( FAILED( Hr = CreateSurfaces() ) ) return Hr;
   return S_OK;
}

HRESULT CBackground::ReleaseSurfaces()
{
   return S_OK;
}

HRESULT CBackground::Draw()
{
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_LIGHTING, FALSE);
   _Engine.m_pD3DDevice->SetTexture(0, _Engine.m_ppTextures[m_iTexture]);
   _Engine.m_pD3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX,
                                        m_Background, 4, 0 );
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_LIGHTING, TRUE);
   return S_OK;
}
