
#include "stdafx.h"
#include "Actor.h"

//////////////////////////////////////////////////////////////////////////////
//
// CActor
//

CActor::CActor()
{
   m_szModelFilename[0] = '\0';
   m_szSkinFilename[0] = '\0';
   m_cull = true;
     m_fScale = 0.3f;
   ZeroMemory(src_v, sizeof(src_v));

   ZeroMemory(m_Bones,sizeof(m_Bones));
   for( int i=0; i<MAX_NUM_BONES; i++ ) m_Bones[i].dwID = -1;
};

CActor::~CActor()
{
};

HRESULT CActor::Initialize(CSystem *, CEngine *)
{
   return S_OK;
}

HRESULT CActor::SetProperty(LPCSTR szItem, LPCSTR szValue)
{
   if( stricmp(szItem,"BONES")==0 ) return S_OK; // valid, but not parsable

   if( stricmp(szItem,"FILENAME")==0 ) {
      strcpy( m_szModelFilename, szValue );
      return S_OK;
   }
   if( stricmp(szItem,"SKIN")==0 ) {
      strcpy( m_szSkinFilename, szValue );
      return S_OK;
   }
   if( stricmp(szItem,"SCALE")==0 ) {
      m_fScale = (float)atof(szValue);
      return S_OK;
   };
   if( stricmp(szItem,"CULL")==0 ) {
      m_cull = (_toupper(szValue[0])=='Y');
      return S_OK;
   };
   return E_INVALIDARG;
}

HRESULT CActor::Create()
{
   CHAR szFilename[MAX_PATH];

   strcpy( szFilename, _System.m_szResPath );
   strcat( szFilename, m_szSkinFilename );
   CPCX pcx;
   LPDIRECTDRAWSURFACE7 pSurface;
   HRESULT Hr = pcx.CreateSurface(szFilename, &pSurface);
   if( FAILED(Hr) ) return Hr;
   _Engine.CreateTexture(pSurface,m_iTexture);

   CFile f;
   strcpy( szFilename, _System.m_szResPath );
   strcat( szFilename, m_szModelFilename );
   if( f.Open(szFilename)==FALSE ) return E_FAIL;

   MD2HeaderStruct Header;
   f.Read(&Header, sizeof(Header));
   if(Header.dwID != ('I' + ('D' << 8) + ('P' << 16) + ('2' << 24))) return E_FAIL;
   if(Header.dwVersion != 8) return E_FAIL;

   DWORD dwNumFrames = Header.dwNumFrames;
   DWORD dwNumVertsPerFrame = Header.dwNumXYZ;
   m_dwNumVertices = dwNumVertsPerFrame;
   DWORD Vertice;

   m_pVertices = new D3DVERTEX[m_dwNumVertices];
   if(m_pVertices== NULL) return E_OUTOFMEMORY;
   ZeroMemory(m_pVertices, sizeof(D3DVERTEX)*m_dwNumVertices);

   // Move file pointer to the start of the GL command list
   f.Seek(Header.dwOffGLCmds, FILE_BEGIN);
   m_dwNumPrimitives = 0;
   long id = 1;
   while( id!=0 ) {   
      // Read in primitive commands from md2 file
      f.Read(&id,sizeof(int));
      // id = 0 indicates the end of the command list
      if(id != 0)   {
         DWORD dwSize = abs(id) * (sizeof(float)+sizeof(float)+sizeof(int));
         f.Seek(dwSize, FILE_CURRENT);
         m_dwNumPrimitives++;
      };
   };

   f.Seek(Header.dwOffGLCmds, FILE_BEGIN);
   m_pPrimitives = new MD2AliasPrimitiveStruct[m_dwNumPrimitives];
   id = 1;
   DWORD idx=0;
   while( id!=0 ) {   
      // Read in primitive commands from md2 file
      f.Read(&id,sizeof(int));
      // id = 0 indicates the end of the command list
      if(id != 0)   {
         DWORD IndicesCount = abs(id);
         if(id < 0 ) m_pPrimitives[idx].PrimitiveType = D3DPT_TRIANGLEFAN;
         if(id > 0 ) m_pPrimitives[idx].PrimitiveType = D3DPT_TRIANGLESTRIP;      
         m_pPrimitives[idx].FaceIndices = new MD2AliasFaceIndexStruct[IndicesCount];
         m_pPrimitives[idx].NumFaceIndices = IndicesCount;
         for(Vertice = 0; Vertice < IndicesCount; Vertice++) {
            // Read texture co-ordinates s and t, and face index
            float fs, ft;
            long N;
            f.Read(&fs,sizeof(float));
            f.Read(&ft,sizeof(float));
            f.Read(&N,sizeof(int));
            m_pPrimitives[idx].FaceIndices[Vertice].s = fs;
            m_pPrimitives[idx].FaceIndices[Vertice].t = ft;
            m_pPrimitives[idx].FaceIndices[Vertice].index = N;
         }      
         idx++;
      }
   }

   f.Seek(Header.dwOffFrames, FILE_BEGIN);
   MD2AliasFrameStruct Frame;
   f.Read(&Frame, sizeof(Frame));

   MD2TriVertStruct *pVerts;
   pVerts = new MD2TriVertStruct[m_dwNumVertices];
   if( pVerts==NULL ) return E_OUTOFMEMORY;
   f.Read(pVerts, sizeof(MD2TriVertStruct) * m_dwNumVertices);
   float m_fScale = 0.3f;
   for(Vertice = 0; Vertice < dwNumVertsPerFrame; Vertice++) 
   {
      m_pVertices[Vertice].dvX = (pVerts[Vertice].bVerts[0] * Frame.fScale[0] + Frame.fTranslate[0]) * m_fScale;
      m_pVertices[Vertice].dvY = (pVerts[Vertice].bVerts[1] * Frame.fScale[1] + Frame.fTranslate[1]) * m_fScale;
      m_pVertices[Vertice].dvZ = (pVerts[Vertice].bVerts[2] * Frame.fScale[2] + Frame.fTranslate[2]) * m_fScale;
   }
   delete pVerts;

   f.Close();

   return S_OK;
};

HRESULT CActor::Done()
{
   return S_OK;
}

HRESULT CActor::CreateSurfaces()
{
   if( m_Bones[0].dwID==-1 ) return E_FAIL; // must have at least one bone
   return S_OK;
}

HRESULT CActor::RestoreSurfaces()
{
   HRESULT Hr;
   if( FAILED( Hr = ReleaseSurfaces() ) ) return Hr;
   if( FAILED( Hr = CreateSurfaces() ) ) return Hr;
   return S_OK;
}

HRESULT CActor::ReleaseSurfaces()
{
   return S_OK;
}

HRESULT CActor::Draw()
{
   DrawBones();
   DeformVertices();
   DrawModel();
   return S_OK;
}

HRESULT CActor::DrawBones()
{
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, m_cull ? D3DCULL_CW : D3DCULL_NONE );
   DrawBone(0);
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CCW);
   return S_OK;
};

HRESULT CActor::DrawBone(DWORD dwId)
{
   tBone &b = m_Bones[dwId];

   D3DVECTOR size = b.vecSize * b.vecScale;

   D3DVERTEX v[9];
   v[0] = D3DVERTEX(D3DVECTOR(-size.dvX,-size.dvY,-size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[1] = D3DVERTEX(D3DVECTOR(+size.dvX,-size.dvY,-size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[2] = D3DVERTEX(D3DVECTOR(+size.dvX,+size.dvY,-size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[3] = D3DVERTEX(D3DVECTOR(-size.dvX,+size.dvY,-size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[4] = D3DVERTEX(D3DVECTOR(-size.dvX,-size.dvY,-size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[5] = D3DVERTEX(D3DVECTOR(-size.dvX,-size.dvY,+size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[5] = D3DVERTEX(D3DVECTOR(+size.dvX,-size.dvY,+size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[6] = D3DVERTEX(D3DVECTOR(+size.dvX,+size.dvY,+size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[7] = D3DVERTEX(D3DVECTOR(-size.dvX,+size.dvY,+size.dvZ), D3DVECTOR(0,0,-1), 0,0);
   v[8] = D3DVERTEX(D3DVECTOR(-size.dvX,-size.dvY,+size.dvZ), D3DVECTOR(0,0,-1), 0,0);

   _Engine.m_pD3DDevice->DrawPrimitive(D3DPT_LINESTRIP,
                                       D3DFVF_VERTEX,
                                       v,
                                       9,
                                       D3DDP_WAIT);

   for( int i=0; i<MAX_NUM_BONES; i++ ) {
      if( m_Bones[i].dwID!=-1 && 
          m_Bones[i].dwParent==dwId ) 
          DrawBone(m_Bones[i].dwID);
   };
   return S_OK;
};

HRESULT CActor::DeformVertices()
{
   return S_OK;
}

HRESULT CActor::DrawModel()
{
   HRESULT Hr;
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, m_cull ? D3DCULL_CW : D3DCULL_NONE );
   Hr = _Engine.m_pD3DDevice->SetTexture(0, _Engine.m_ppTextures[m_iTexture]);

   // Go through the list of polys one by one and render then
   for(DWORD prim_cnt = 0; prim_cnt < m_dwNumPrimitives; prim_cnt++) {
      // Get the number of indices (indexes) for this poly
      DWORD num_indices = m_pPrimitives[prim_cnt].NumFaceIndices;
      // Number of texture co-ordinates is the same as the number of indices
      DWORD num_tex_indices = num_indices;

      // Get the Id value for the current prim
      D3DPRIMITIVETYPE PrimitiveType = m_pPrimitives[prim_cnt].PrimitiveType;
      // Go through all the indices, and texture co-ordinates for this poly
      float wx=0.0f, wy=8.2f, wz=0.0f;

      for(DWORD index_cnt = 0; index_cnt < num_indices; index_cnt++) {
         long index = m_pPrimitives[prim_cnt].FaceIndices[index_cnt].index;

         float tex_coord_s = m_pPrimitives[prim_cnt].FaceIndices[index_cnt].s;
         float tex_coord_t = m_pPrimitives[prim_cnt].FaceIndices[index_cnt].t;

         // Note : swap Y and Z co-ordinates because MD2 models have 
         // the Z axis as the up axis, and we use the Y axis as up in this sample.
         float x,y,z;
         x = m_pVertices[index].x;
         z = m_pVertices[index].y;
         y = m_pVertices[index].z;

         src_v[index_cnt].x  = wx + x; 
         src_v[index_cnt].y  = wy + y;
         src_v[index_cnt].z  = wz + z;
         src_v[index_cnt].tu = tex_coord_s;
         src_v[index_cnt].tv = tex_coord_t;
      }

      if( _Engine.m_pD3DDevice->DrawPrimitive(PrimitiveType, 
                              D3DFVF_VERTEX, 
                              (LPVOID)&src_v, 
                              (DWORD)num_indices, 
                              NULL ) != D3D_OK ) 
      {
         return E_FAIL;
      }
   }
   
   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CCW);
   if(FAILED(Hr)) return Hr;
   return S_OK;
}

HRESULT CActor::AddBone(DWORD dwId,
                        DWORD dwParent,
                        LPSTR szName,
                        D3DVECTOR &size,
                        D3DVECTOR &pivot,
                        D3DVECTOR &trans,
                        D3DVECTOR &scale,
                        D3DVECTOR &rot,
                        D3DVECTOR &min_rot,
                        D3DVECTOR &max_rot)
{
   if( dwId<0 || dwId>=MAX_NUM_BONES ) return E_INVALIDARG;
   if( szName==NULL ) return E_INVALIDARG;
   if( m_Bones[dwId].dwID!=-1 ) return E_INVALIDARG; // bone already defined
   if( m_Bones[dwParent].dwID==-1 ) return E_INVALIDARG; // parent not defined
   if( dwId!=0 && dwParent==-1 ) return E_INVALIDARG; // non-roots must have parent
   if( dwId==0 ) 
      dwParent = -1; // root never has a parent
   else
      if( dwParent<0 || dwParent>=MAX_NUM_BONES ) return E_INVALIDARG;
   tBone Bone;
   Bone.dwID = dwId;
   Bone.dwParent = dwParent;
   Bone.vecSize = size;
   Bone.vecScale = scale;
   Bone.vecMaxRot = max_rot;
   Bone.vecMinRot = min_rot;
   Bone.vecPivot = pivot;
   Bone.vecTrans = trans;
   strcpy( Bone.szName, szName );
   m_Bones[dwId] = Bone;
   return S_OK;
};
