// RegValues.h : Declaration of the CRegValues
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __REGVALUES_H_
#define __REGVALUES_H_

#include "resource.h"       // main symbols

class CRegValue;


/////////////////////////////////////////////////////////////////////////////
// CRegValues

class ATL_NO_VTABLE CRegValues : 
   public CComObjectRootEx<CComObjectThreadModel>,
   public CComCoClass<CRegValues, &CLSID_RegValues>,
   public ISupportErrorInfoImpl<&IID_IRegValues>,
   public IObjectSafetyImpl<CRegValues, INTERFACESAFE_FOR_UNTRUSTED_CALLER>,
   public IDispatchImpl<IRegValues, &IID_IRegValues, &LIBID_EasyRegLib>
{
public:
   CRegValues()
   {
   }

DECLARE_REGISTRY(CRegValues, "EasyReg.RegValues.1", "EasyReg.RegValues", IDS_REGVALUES_DESC, THREADFLAGS_BOTH)
DECLARE_NOT_AGGREGATABLE(CRegValues)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRegValues)
   COM_INTERFACE_ENTRY(IRegValues)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(IObjectSafety)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// IRegValues
public:
   STDMETHOD(get_Item)(/*[in]*/ VARIANT Index, /*[out, retval]*/ IRegValue** ppvObject);
   STDMETHOD(get_Count)(/*[out, retval]*/ long* ppRetVal);
   STDMETHOD(get__NewEnum)(/*[out, retval]*/ IUnknown** ppunk);
   STDMETHOD(Add)(/*[in]*/ BSTR Item, /*[out, retval]*/ IRegValue** ppvObject);
   STDMETHOD(Remove)(/*[in]*/ VARIANT Index);   

// Implementation
public:
   HRESULT LocateValue(CRegKey &reg, VARIANT Index, LPTSTR szItem, DWORD cchItem);
   HRESULT GetValue(CRegKey &reg, LPCTSTR szItem, CComVariant &Result);
   HRESULT InitValue(CRegValue *pObj, HKEY hkeyRoot, BSTR sBranch, LPCTSTR sName, CComVariant &vValue);

// Attributes
public:
  HKEY m_hkeyRoot;
  CComBSTR m_sBranch;
};

#endif //__REGVALUES_H_
