// RegNodes.h : Declaration of the CRegNodes
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __REGNODES_H_
#define __REGNODES_H_

#include "resource.h"       // main symbols

class CRegNode;


/////////////////////////////////////////////////////////////////////////////
// CRegNodes

class ATL_NO_VTABLE CRegNodes : 
   public CComObjectRootEx<CComObjectThreadModel>,
   public CComCoClass<CRegNodes, &CLSID_RegNodes>,
   public ISupportErrorInfoImpl<&IID_IRegNodes>,
   public IObjectSafetyImpl<CRegNodes, INTERFACESAFE_FOR_UNTRUSTED_CALLER>,
   public IDispatchImpl<IRegNodes, &IID_IRegNodes, &LIBID_EasyRegLib>
{
public:
   CRegNodes()
   {
   }

DECLARE_REGISTRY(CRegNodes, "EasyReg.RegNodes.1", "EasyReg.RegNodes", IDS_REGNODES_DESC, THREADFLAGS_BOTH)
DECLARE_NOT_AGGREGATABLE(CRegNodes)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRegNodes)
   COM_INTERFACE_ENTRY(IRegNodes)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(IObjectSafety)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// IRegNodes
public:
   STDMETHOD(get_Item)(/*[in]*/ VARIANT Item, /*[out, retval]*/ IRegNode** ppvObject);
   STDMETHOD(get_Count)(/*[out, retval]*/ long* ppRetVal);
   STDMETHOD(get__NewEnum)(/*[out, retval]*/ IUnknown** ppunk);
   STDMETHOD(Add)(/*[in]*/ BSTR Item, /*[out, retval]*/ IRegNode** ppvObject);
   STDMETHOD(Remove)(/*[in]*/ BSTR Item);   

// Implementation
public:
  HRESULT LocateNode(CRegKey &reg, VARIANT Index, LPTSTR szItem=NULL, DWORD cchItem=0);
  HRESULT InitNode(CRegNode *pObj, HKEY hkeyRoot, LPCTSTR sBranch);

// Attributes
public:
  HKEY m_hkeyRoot;
  CComBSTR m_sBranch;
};

#endif //__REGNODES_H_
