// RegNode.h : Declaration of the CRegNode
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __REGNODE_H_
#define __REGNODE_H_

#include "resource.h"       // main symbols


/////////////////////////////////////////////////////////////////////////////
// CRegNode

class ATL_NO_VTABLE CRegNode : 
   public CComObjectRootEx<CComObjectThreadModel>,
   public CComCoClass<CRegNode, &CLSID_RegNode>,
   public ISupportErrorInfoImpl<&IID_IRegNode>,
   public IObjectSafetyImpl<CRegNode, INTERFACESAFE_FOR_UNTRUSTED_CALLER>,
   public IDispatchImpl<IRegNode, &IID_IRegNode, &LIBID_EasyRegLib>
{
public:
   CRegNode()
   {
      m_hkeyRoot = NULL;
   }

DECLARE_REGISTRY(CRegNode, "EasyReg.RegNode.1", "EasyReg.RegNode", IDS_REGNODE_DESC, THREADFLAGS_BOTH)
DECLARE_NOT_AGGREGATABLE(CRegNode)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRegNode)
  COM_INTERFACE_ENTRY(IRegNode)
  COM_INTERFACE_ENTRY(IDispatch)
  COM_INTERFACE_ENTRY(IObjectSafety)
  COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// IRegNode
public:
  STDMETHOD(Set)(/*[in]*/ HKEY RootKey, /*[in]*/ BSTR Key, /*[defaultvalue(VARIANT_TRUE)]*/ VARIANT_BOOL ReadOnly);
  STDMETHOD(get_Root)(/*[out, retval]*/ HKEY *pVal);
  STDMETHOD(get_Name)(/*[out, retval]*/ BSTR *pVal);
  STDMETHOD(get_Values)(/*[out, retval]*/ IRegValues * *pVal);
  STDMETHOD(get_Nodes)(/*[out, retval]*/ IRegNodes * *pVal);

// Attributes
public:
  HKEY m_hkeyRoot;
  CComBSTR m_sBranch;
};

#endif //__REGNODE_H_
