#if !defined(AFX_LISTHEADER_H__20040131_3E28_4FF3_122C_0080AD509054__INCLUDED_)
#define AFX_LISTHEADER_H__20040131_3E28_4FF3_122C_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// DocListHeaderCtrl - ListView header ala Pocket Word
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2004 Bjarke Viksoe.
//
// Add the following macro to the parent's message map:
//   REFLECT_NOTIFICATIONS()
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __cplusplus
  #error WTL requires C++ compilation (use a .cpp suffix)
#endif

#ifndef UNDER_CE
  #error DocListHeader.h compiles under Windows CE only
#endif


/////////////////////////////////////////////////////////////////////////////
// 

#define IDC_TB_DROPDOWN1  1024
#define IDC_TB_MIDDLE     1025
#define IDC_TB_DROPDOWN2  1026


template< class T, class TBase = CToolBarCtrl, class TWinTraits = CControlWinTraits >
class ATL_NO_VTABLE CDocListHeaderImpl : 
   public CWindowImpl< T, TBase, TWinTraits >
{
public:
   DECLARE_WND_SUPERCLASS(NULL, TBase::GetWndClassName())

   // Operations

   BOOL SubclassWindow(HWND hWnd)
   {
      ATLASSERT(m_hWnd==NULL);
      ATLASSERT(::IsWindow(hWnd));
      BOOL bRet = CWindowImpl< T, TBase, TWinTraits >::SubclassWindow(hWnd);
      if( bRet ) _Init();
      return bRet;
   }

   BOOL SetHeaderButton(UINT uSide, UINT nRes, int iBitmap = -1, LPARAM lParam = 0)
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(uSide==HTLEFT || uSide==HTRIGHT);

      TCHAR szText[128] = { 0 };
      ::LoadString(_Module.GetResourceInstance(), nRes, szText, (sizeof(szText) / sizeof(TCHAR)) - 1);

      TBBUTTONINFO tbi = { 0 };
      tbi.cbSize = sizeof(TBBUTTONINFO);
      tbi.dwMask = TBIF_TEXT | TBIF_STATE | TBIF_LPARAM;
      if( iBitmap >= 0 ) tbi.dwMask |= TBIF_IMAGE;
      tbi.pszText = szText;
      tbi.fsState = TBSTATE_ENABLED;
      tbi.iImage = iBitmap;
      tbi.lParam = lParam;
      BOOL bRes = SetButtonInfo(uSide == HTLEFT ? IDC_TB_DROPDOWN1 : IDC_TB_DROPDOWN2, &tbi);
      SendMessage(WM_SIZE);
      return bRes;
   }
   BOOL SetHeaderButtonText(UINT uSide, UINT nRes)
   {
      TCHAR szText[128] = { 0 };
      ::LoadString(_Module.GetResourceInstance(), nRes, szText, (sizeof(szText) / sizeof(TCHAR)) - 1);
      return SetHeaderButtonText(uSide, szText);
   }
   BOOL SetHeaderButtonText(UINT uSide, LPCTSTR pstrText)
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(uSide==HTLEFT || uSide==HTRIGHT);
      TBBUTTONINFO tbi = { 0 };
      tbi.cbSize = sizeof(TBBUTTONINFO);
      tbi.dwMask = TBIF_TEXT;
      tbi.pszText = const_cast<LPTSTR>(pstrText);
      BOOL bRes = SetButtonInfo(uSide == HTLEFT ? IDC_TB_DROPDOWN1 : IDC_TB_DROPDOWN2, &tbi);
      SendMessage(WM_SIZE);
      return bRes;
   }
   POINT GetMenuPos(UINT uSide) const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(uSide==HTLEFT || uSide==HTRIGHT);
      RECT rcItem = { 0 };
      GetItemRect(uSide == HTLEFT ? 0 : 2, &rcItem);
      POINT pt = { uSide == HTLEFT ? rcItem.left : rcItem.right, rcItem.bottom };
      ClientToScreen(&pt);
      return pt;
   }

   // Implementation

   void _Init()
   {
      ATLASSERT(::IsWindow(m_hWnd));

      SendMessage(CCM_SETVERSION, COMCTL32_VERSION);
      ModifyStyle(0, TBSTYLE_CUSTOMERASE | TBSTYLE_FLAT | TBSTYLE_LIST);
      SetButtonStructSize(sizeof(TBBUTTON));

      TBBUTTON buttons[3] = { 0, 0, 0 };
      buttons[0].iBitmap = -1;
      buttons[0].idCommand = IDC_TB_DROPDOWN1;
      buttons[0].fsState = TBSTATE_INDETERMINATE | TBSTATE_HIDDEN;
      buttons[0].fsStyle = TBSTYLE_AUTOSIZE | TBSTYLE_DROPDOWN;
      buttons[0].dwData = 0;
      buttons[0].iString = -1;
      buttons[1].iBitmap = -1;
      buttons[1].idCommand = IDC_TB_MIDDLE;
      buttons[1].fsState = TBSTATE_INDETERMINATE;
      buttons[1].fsStyle = 0;
      buttons[1].dwData = 0;
      buttons[1].iString = -1;
      buttons[2].iBitmap = -1;
      buttons[2].idCommand = IDC_TB_DROPDOWN2;
      buttons[2].fsState = TBSTATE_INDETERMINATE | TBSTATE_HIDDEN;
      buttons[2].fsStyle = TBSTYLE_AUTOSIZE | TBSTYLE_DROPDOWN;
      buttons[2].dwData = 0;
      buttons[2].iString = -1;
      AddButtons(3, buttons);
   }

   // Message map and handlers

   BEGIN_MSG_MAP(CDocListHeaderImpl)
      MESSAGE_HANDLER(WM_CREATE, OnCreate)
      MESSAGE_HANDLER(WM_SIZE, OnSize)      
      REFLECTED_NOTIFY_CODE_HANDLER(TBN_DROPDOWN, OnDropDownArrow)
      REFLECTED_NOTIFY_CODE_HANDLER(NM_CUSTOMDRAW, OnCustomDraw)
   END_MSG_MAP()

   LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      LRESULT lRes = DefWindowProc();
      _Init();
      return lRes;
   }
   LRESULT OnSize(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled)
   {
      // Dynamically resize the middle button
      RECT rcClient;
      GetClientRect(&rcClient);
      int iWidth = rcClient.right - rcClient.left;
      if( (GetState(IDC_TB_DROPDOWN1) & TBSTATE_HIDDEN) == 0 ) {
         RECT rc;
         GetItemRect(0, &rc);
         iWidth -= rc.right - rc.left;
      }
      if( (GetState(IDC_TB_DROPDOWN2) & TBSTATE_HIDDEN) == 0 ) {
         RECT rc;
         GetItemRect(2, &rc);
         iWidth -= rc.right - rc.left;
      }
      TBBUTTONINFO tbi = { 0 };
      tbi.cbSize = sizeof(TBBUTTONINFO);
      tbi.dwMask = TBIF_SIZE;
      tbi.cx = iWidth;
      SetButtonInfo(IDC_TB_MIDDLE, &tbi);
      bHandled = FALSE;
      return 0;
   }
   LRESULT OnDropDownArrow(int /*idCtrl*/, LPNMHDR pnmh, BOOL& bHandled)
   {
      LPNMTOOLBAR lpnmtb = (LPNMTOOLBAR) pnmh;
      ::PostMessage(GetParent(), WM_COMMAND, MAKEWPARAM(lpnmtb->iItem, 0), 0L);
      bHandled = FALSE;
      return 0;
   }
   LRESULT OnCustomDraw(int /*idCtrl*/, LPNMHDR pnmh, BOOL& bHandled)
   {
      LPNMCUSTOMDRAW lplvcd = (LPNMCUSTOMDRAW) pnmh;
      switch( lplvcd->dwDrawStage ) {
      case CDDS_PREPAINT :
         {
            CDCHandle dc = lplvcd->hdc;
            RECT rcClient;
            GetClientRect(&rcClient);
            RECT rcLine = { rcClient.left, rcClient.bottom - 1, rcClient.right, rcClient.bottom };
            dc.FillSolidRect(&rcLine, RGB(0,0,0));
         }
         return CDRF_NOTIFYITEMDRAW;
      case CDDS_ITEMPREPAINT:
         return CDRF_NOVERTBAR;
      }
      bHandled = FALSE;
      return 0;
   }
};

class CDocListHeaderCtrl : public CDocListHeaderImpl<CDocListHeaderCtrl, CToolBarCtrl, CWinTraitsOR<TBSTYLE_CUSTOMERASE | TBSTYLE_FLAT | TBSTYLE_LIST | CCS_NODIVIDER | CCS_TOP> >
{
public:
   DECLARE_WND_SUPERCLASS(_T("WTL_DocListHeader"), GetWndClassName())  
};


#endif // !defined(AFX_LISTHEADER_H__20040131_3E28_4FF3_122C_0080AD509054__INCLUDED_)
