// CollapsibleTestView.h : interface of the CCollapsibleTestView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_COLLAPSIBLETESTVIEW_H__2B5D4682_F2E0_4514_8C8B_9823859F866A__INCLUDED_)
#define AFX_COLLAPSIBLETESTVIEW_H__2B5D4682_F2E0_4514_8C8B_9823859F866A__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "atlgdix.h"
#include "CollapsiblePanel.h"


class CPanel1 : public CDialogImpl<CPanel1>
{
public:
   enum { IDD = IDD_VIEW1 };

   CBrush m_brBack;
   CHyperLink m_ctrlLink1;
   CHyperLink m_ctrlLink2;

   BEGIN_MSG_MAP(CPanel1)
      MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
      MESSAGE_HANDLER(WM_CTLCOLORDLG, OnCtlColorDlg)
      MESSAGE_HANDLER(WM_CTLCOLORSTATIC, OnCtlColorDlg)
   END_MSG_MAP()

   LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      m_brBack.CreateSolidBrush(RGB(240,241,245));
      m_ctrlLink1.SubclassWindow(GetDlgItem(IDC_LINK1));
      m_ctrlLink1.SetHyperLink(_T("http://www.viksoe.dk/code"));
      m_ctrlLink2.SubclassWindow(GetDlgItem(IDC_LINK2));
      m_ctrlLink2.SetHyperLink(_T("http://groups.yahoo.com/groups/wtl"));
      return 0;
   }
   LRESULT OnCtlColorDlg(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      return (LRESULT) (HBRUSH) m_brBack;
   }
};


class CPanel2 : public CDialogImpl<CPanel2>
{
public:
   enum { IDD = IDD_VIEW2 };

   CBrush m_brBack;
   CHyperLink m_ctrlLink;

   BEGIN_MSG_MAP(CPanel2)
      MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
      MESSAGE_HANDLER(WM_CTLCOLORDLG, OnCtlColorDlg)
      MESSAGE_HANDLER(WM_CTLCOLORSTATIC, OnCtlColorDlg)
   END_MSG_MAP()

   LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      m_brBack.CreateSolidBrush(RGB(240,241,245));
      m_ctrlLink.SubclassWindow(GetDlgItem(IDC_LINK));
      m_ctrlLink.SetHyperLink(_T("http://montgomery.thefreelibrary.com/Anne-Of-Green-Gables/")); 
      return 0;
   }
   LRESULT OnCtlColorDlg(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      CDCHandle dc = (HDC) wParam;
      dc.SetBkMode(TRANSPARENT);
      return (LRESULT) (HBRUSH) m_brBack;
   }
};


class CView : public CCollapsiblePanelImpl<CView>
{
public:
   DECLARE_WND_CLASS(_T("WTL_CollapsiblePanel"))

   typedef CCollapsiblePanelImpl<CView> parentClass;

   CImageList m_Images;
   CPanel1 m_view1;
   CPanel2 m_view2;
   CPanel1 m_view3;
      
   BOOL PreTranslateMessage(MSG* pMsg)
   {
      pMsg;
      return FALSE;
   }

   BEGIN_MSG_MAP(CCollapsibleTestView)
      MESSAGE_HANDLER(WM_CREATE, OnCreate)
      CHAIN_MSG_MAP( parentClass )
   END_MSG_MAP()

   LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      LRESULT lRes = parentClass::OnCreate(uMsg, wParam, lParam, bHandled);

      m_Images.CreateFromImage(MAKEINTRESOURCE(IDB_HEADERS), 32, 0, RGB(0,128,128), IMAGE_BITMAP, LR_CREATEDIBSECTION);
      SetImageList(m_Images, LVSIL_NORMAL);

      m_view1.Create(m_hWnd);
      m_view2.Create(m_hWnd);
      m_view3.Create(m_hWnd);

      //SetExtendedPanelStyle(CPS_EX_FLATSTYLE);
      //SetExtendedPanelStyle(CPS_EX_SELHIGHLIGHT | CPS_EX_NOSCROLLBAR);      
      SetExpandBitmaps(IDI_EXPAND, IDI_COLLAPSE);
      InsertItem(m_view1, _T("File and Folder Tasks"));
      InsertItem(m_view2, _T("Details"), 0);
      InsertItem(m_view3, _T("Links"));
      SetItemExpanded(0, FALSE);
      //SetItemColors(0, RGB(255,255,255), RGB(0,0,0), RGB(0,0,0));
      //SetItemEnabled(1, FALSE);
      //PANELTHEME theme = GetPanelTheme();
      //SetPanelTheme(theme);

      return lRes;
   }
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_COLLAPSIBLETESTVIEW_H__2B5D4682_F2E0_4514_8C8B_9823859F866A__INCLUDED_)
