#if !defined(AFX_MISC_H__19981017_81DF_64CB_33A4_0080AD509054__INCLUDED_)
#define AFX_MISC_H__19981017_81DF_64CB_33A4_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


///////////////////////////////////////////////////////////////////

typedef int FRAMEPOS;


///////////////////////////////////////////////////////////////////

typedef enum {
   TOOL_DEFAULT,
   TOOL_SELECT,
   TOOL_MOVE,
   TOOL_ROTATE,
   TOOL_SIZE,
   TOOL_ZOOM,
} TOOLMODE;

typedef enum {
   VIEW_VIEW,
   VIEW_OBJECT,
   VIEW_VERTEX,
   VIEW_BONES,
   VIEW_CAMERA,
   //
   VIEW_SELECT,
   VIEW_RENDER,
} VIEWTYPE;

typedef enum {
   DIR_X,
   DIR_Y,
   DIR_Z,
   DIR_XY,
} DIRECTION;

typedef enum {
   DIR_LEFT,
   DIR_RIGHT,
   DIR_TOP,
   DIR_BOTTOM,
   DIR_CUSTOM,
} VIEWDIR;

typedef enum {
   SEL_ADD,
   SEL_REMOVE,
   SEL_ADD_ALL,
   SEL_REMOVE_ALL,
} SELECTMODE;

typedef struct {
   RENDERMODE RenderMode;      // Current render type
   VIEWTYPE   CurrentView;     // Current object view
   VIEWDIR    ViewDirection;   // Direction of looking
   DIRECTION  Direction;
   CPoint     StartPoint;      // Original mouse position (OnMouseDown)
   CPoint     CurPoint;        // Current mouse position (OnMouseMove)
   CPoint     OrgPoint;        // Original mouse position (Last OnMouseMove)
   FRAMEPOS   frame;           // Current frame pos
   int        NumSelections;   // Number of objects selectwed
   //
   tVector    trans;
   tVector    rot;
   struct {
      tVector forward;
      tVector right;
      tVector vright;
      tVector vup;
      tVector vpn;
   } camera;
} TRenderDef;


typedef struct {
   float x,y,z;
} tCoord;


///////////////////////////////////////////////////////////////////

void KfxCheckOpenGLForErrors(void);
void KfxRemoveOpenGLErrors(void);
void KfxRotateCoord(GLfloat coord[3], GLfloat angle[3], GLfloat output[3]);
void KfxMultVectorByMatrix(tMatrix mat, tVector v,tVector result);

#endif // !defined(AFX_MISC_H__19981017_81DF_64CB_33A4_0080AD509054__INCLUDED_)

