// Vector.h: interface for the CVector class.
//
// Description:
// A few macros and functions to handle
// vectors and matrix calculations
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VECTOR_H__C7B2A584_652F_11D2_80BE_0080AD509054__INCLUDED_)
#define AFX_VECTOR_H__C7B2A584_652F_11D2_80BE_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define	PI	3.14159265358979323846f

typedef float tVector[3];
typedef float tMatrix[16];

#define VectorClear(a)			(a[0]=a[1]=a[2]=0.0f)
#define VectorSet(v, x,y,z)	(v[0]=(x), v[1]=(y), v[2]=(z))
#define VectorCopy(a,b)			(b[0]=a[0],b[1]=a[1],b[2]=a[2])
#define VectorNegate(a,b)		(b[0]=-a[0],b[1]=-a[1],b[2]=-a[2])
#define VectorAdd(a,b,c)		(c[0]=a[0]+b[0],c[1]=a[1]+b[1],c[2]=a[2]+b[2])
#define VectorSubtract(a,b,c)	(c[0]=a[0]-b[0],c[1]=a[1]-b[1],c[2]=a[2]-b[2])
#define DotProduct(x,y)			(x[0]*y[0]+x[1]*y[1]+x[2]*y[2])

#define MatrixClear(m) { for(int i=0; i<16; i++ ) m[i]=0.0f; };

void  VectorCrossProduct(tVector v1, tVector v2, tVector output);
float VectorNormalize(tVector v);
float VectorLength(tVector v);
void  VectorMA(tVector va, float scale, tVector vb, tVector output);


#endif // !defined(AFX_VECTOR_H__C7B2A584_652F_11D2_80BE_0080AD509054__INCLUDED_)
