// Vector.cpp: implementation of the CVector class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharAnim.h"
#include "Vector.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


float VectorLength(tVector v)
{
	float	length = 0.0f;
	for( int i=0 ; i< 3; i++)  length += v[i]*v[i];
	length = (float)sqrt(length); // performance killer!
	return length;
}

float VectorNormalize(tVector v)
{
	int i;
	float	length = 0.0f;
	for( i=0 ; i< 3; i++ ) length += v[i]*v[i];
	length = (float)sqrt (length);
	if( length==0 ) return (float)0.0f; // to avoid div-by-zero exception
	for( i=0 ; i< 3; i++ ) v[i] /= length;	
	return length;
}

void VectorMA(tVector va, float scale, tVector vb, tVector output)
{
	output[0] = va[0] + scale*vb[0];
	output[1] = va[1] + scale*vb[1];
	output[2] = va[2] + scale*vb[2];
}

void VectorCrossProduct(tVector v1, tVector v2, tVector output)
{
	output[0] = v1[1]*v2[2] - v1[2]*v2[1];
	output[1] = v1[2]*v2[0] - v1[0]*v2[2];
	output[2] = v1[0]*v2[1] - v1[1]*v2[0];
}
