// OpenGLView.h: interface for the COpenGLView class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENGLVIEW_H__C8076413_66C9_11D2_80C5_0080AD509054__INCLUDED_)
#define AFX_OPENGLVIEW_H__C8076413_66C9_11D2_80C5_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef enum {
	WIREFRAME = 1,
   WIREFRONT,
   SHADE,
	TEXTURE,
} RENDERMODE;

/////////////////////////////////////////////////////////////////////////////
// COpenGLView view

class COpenGLView : public CObject
{
public:
	COpenGLView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(COpenGLView)

// Attributes
public:
   HGLRC m_hGLRC;
	CDC  *m_dc;
   HPALETTE m_hPalette;
   int m_nWidth;
   int m_nHeight;

// Operations
public:
   void SetDefaults(RENDERMODE RenderMode);
   void Destroy();
   //
   void ChangeRenderMode(RENDERMODE RenderMode);
   void RedoPalette();
   //
   void InitRender();
   void DoneRender();
   //
   void FitRect(CRect &rc);
   void SetCurrent();
	//
   BOOL IsGLRCValid(void) const { return m_hGLRC!=NULL; };
   BOOL IsPaletteValid(void) const { return m_hPalette!=NULL; };
   //
   CDC *GetDC(void) const { return m_dc; };
   HGLRC GetHGLRC(void) const { return m_hGLRC; };
   HPALETTE Getpalette(void) const { return m_hPalette; };
   int GetWidth(void) const { return m_nWidth; };
   int GetHeight(void) const { return m_nHeight; };

// Implementation
protected:
   void SetupPixelFormat(CDC *dc);
   void SetupPalette(CDC *dc);

// Overrides
/*	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenGLView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL*/

// Implementation
public:
	virtual ~COpenGLView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	virtual void OnInitialUpdate();
   virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	
   int OnCreate(LPCREATESTRUCT lpCreateStruct, CDC *dc);
	void OnSize(UINT nType, int cx, int cy);
	BOOL OnEraseBkgnd(CDC* pDC);
	void OnDestroy();
   void OnSetFocus(CWnd* pOldWnd);

	// Generated message map functions
protected:
/*	//{{AFX_MSG(COpenGLView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()*/
};

/////////////////////////////////////////////////////////////////////////////


#endif // !defined(AFX_OPENGLVIEW_H__C8076413_66C9_11D2_80C5_0080AD509054__INCLUDED_)
