// OpenGLView.cpp: implementation of the COpenGLView class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharAnim.h"
#include "OpenGLView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
// COpenGLView

IMPLEMENT_DYNCREATE(COpenGLView, CObject)

COpenGLView::COpenGLView()
{
   m_hGLRC = NULL;
   m_hPalette = NULL;
   m_dc = NULL;
}

COpenGLView::~COpenGLView()
{
   Destroy();
}


/*BEGIN_MESSAGE_MAP(COpenGLView, CObject)
	//{{AFX_MSG_MAP(COpenGLView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()*/


/////////////////////////////////////////////////////////////////////////////
// COpenGLView diagnostics

#ifdef _DEBUG
void COpenGLView::AssertValid() const
{
	CObject::AssertValid();
}

void COpenGLView::Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// COpenGLView initializers

void COpenGLView::Destroy()
{
   if( m_hGLRC!=NULL ) {
      ::wglMakeCurrent(NULL, NULL);
      ::wglDeleteContext(m_hGLRC);
      m_hGLRC = NULL;
	}
   if( m_hPalette!=NULL ) {
      ::DeleteObject(m_hPalette);
      m_hPalette = NULL;
   }
   if( m_dc!=NULL ) {
      delete m_dc;
      m_dc = NULL;
   };
};

BOOL COpenGLView::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style |= CS_HREDRAW | CS_VREDRAW;
   cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
   cs.style &= ~CS_PARENTDC;
	//return CObject::PreCreateWindow(cs);
   return TRUE;
}

void COpenGLView::SetDefaults(RENDERMODE RenderMode)
{
   //
   // Prepare opengl settings
   //
   glClearColor(0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_SMOOTH);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective (40, 1, 1,800);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

   //glTranslatef(0.0F, 0.0F, -70.0F);
	glRotatef(-90.0F, 1.0F, 0.0F, 0.0F); // make z up
	glRotatef(90.0F, 0.0F, 0.0F, 1.0F);

	glEnable(GL_DEPTH_TEST); // let's do z buffering
	glEnable(GL_LIGHT0);

	glCullFace(GL_BACK); // hidden surface removal

	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

//	glTexImage2D(GL_TEXTURE_2D, 0, 4, imageTexture.m_iscaledWidth, imageTexture.m_iscaledHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, imageTexture.glTexture);

   //
   // Set point size
   //
   GLint psize[2];
   ::glDisable(GL_POINT_SMOOTH);
   ::glGetIntegerv(GL_POINT_SIZE_RANGE,psize);
   if( psize[1]>=4 ) 
      ::glPointSize(4.0f);

   ChangeRenderMode( RenderMode );
};

//////////////////////////////////////////////////////////////////////

void COpenGLView::ChangeRenderMode(RENDERMODE RenderMode)
{
   glMatrixMode(GL_MODELVIEW);
   switch( RenderMode ) {
   case WIREFRAME:
		glDisable(GL_CULL_FACE);
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
	   glDisable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
      glDisable(GL_TEXTURE_1D);

      glShadeModel(GL_FLAT);
		glColor3f(0.0, 1.0, 0.0);
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      break;
   case WIREFRONT:
		glEnable(GL_CULL_FACE);
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
	   glDisable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
      glDisable(GL_TEXTURE_1D);
      
      glShadeModel(GL_FLAT);
		glColor3f (0.0, 1.0, 0.0);
		glPolygonMode(GL_FRONT, GL_LINE);
      break;
   case SHADE:
      glEnable(GL_CULL_FACE);
		glDisable(GL_TEXTURE_2D);
   	glDisable(GL_LIGHT0);
   	glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);

		glPolygonMode(GL_FRONT, GL_FILL);
      glShadeModel(GL_SMOOTH);
		glColor3f(0.8F, 0.8F, 0.8F);
		glDepthFunc (GL_LEQUAL);
      break;
   case TEXTURE:
		glEnable(GL_CULL_FACE);
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
   	glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);

      glShadeModel(GL_FLAT);
		glColor3f(0.0F, 0.0F, 0.0F);
		glPolygonMode (GL_FRONT, GL_FILL);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
		glDepthFunc (GL_LEQUAL);
	   // improve texture mapping speed
	   glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
      break;
   default:
      ASSERT(FALSE); // invalid mode
      return;
   }
};

void COpenGLView::RedoPalette()
{
	ASSERT_VALID(m_dc);
   ::UnrealizeObject(m_hPalette);
   ::SelectPalette(m_dc->m_hDC, m_hPalette, FALSE);
   ::RealizePalette(m_dc->m_hDC);
};

void COpenGLView::SetupPixelFormat(CDC *dc)
{
	ASSERT_VALID(dc);

   PIXELFORMATDESCRIPTOR pfd = {
		sizeof(PIXELFORMATDESCRIPTOR),  /* size */
		1,                              /* version */
		PFD_SUPPORT_OPENGL |
		PFD_DRAW_TO_WINDOW |
		PFD_DOUBLEBUFFER,               /* support double-buffering */
		PFD_TYPE_RGBA,                  /* color type */
		16,                             /* prefered color depth */
		0, 0, 0, 0, 0, 0,               /* color bits (ignored) */
		0,                              /* no alpha buffer */
		0,                              /* alpha bits (ignored) */
		0,                              /* no accumulation buffer */
		0, 0, 0, 0,                     /* accum bits (ignored) */
		16,                             /* depth buffer */
		0,                              /* no stencil buffer */
		0,                              /* no auxiliary buffers */
		PFD_MAIN_PLANE,                 /* main layer */
		0,                              /* reserved */
		0, 0, 0,                        /* no layer, visible, damage masks */
	};
	int pixelFormat;

   pixelFormat = ::ChoosePixelFormat(dc->m_hDC, &pfd);
	if( pixelFormat == 0 ) {
      ::AfxMessageBox(_T("ChoosePixelFormat failed."), MB_ICONERROR|MB_OK);
		exit(1);
	}
   if( ::SetPixelFormat(dc->m_hDC, pixelFormat, &pfd) != TRUE ) {
      ::AfxMessageBox(_T("SetPixelFormat failed."), MB_ICONERROR|MB_OK);
		exit(1);
	}
}

void COpenGLView::SetupPalette(CDC *dc)
{
	ASSERT_VALID(dc);
   PIXELFORMATDESCRIPTOR pfd;
	LOGPALETTE* pPal;
	int paletteSize;

	int pixelFormat = GetPixelFormat(dc->m_hDC);

   ::DescribePixelFormat(dc->m_hDC, pixelFormat, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

	if (pfd.dwFlags & PFD_NEED_PALETTE) {
		paletteSize = 1 << pfd.cColorBits;
	} else {
		return;
	}

	pPal = (LOGPALETTE*)
		malloc(sizeof(LOGPALETTE) + paletteSize * sizeof(PALETTEENTRY));
	pPal->palVersion = 0x300;
	pPal->palNumEntries = paletteSize;

	// Build a simple RGB color palette
	{
		int redMask = (1 << pfd.cRedBits) - 1;
		int greenMask = (1 << pfd.cGreenBits) - 1;
		int blueMask = (1 << pfd.cBlueBits) - 1;
		int i;

		for (i=0; i<paletteSize; ++i)
		{
			pPal->palPalEntry[i].peRed =
				(((i >> pfd.cRedShift) & redMask) * 255) / redMask;
			pPal->palPalEntry[i].peGreen =
				(((i >> pfd.cGreenShift) & greenMask) * 255) / greenMask;
			pPal->palPalEntry[i].peBlue =
				(((i >> pfd.cBlueShift) & blueMask) * 255) / blueMask;
			pPal->palPalEntry[i].peFlags = 0;
		}
	}

   m_hPalette = (HPALETTE)::CreatePalette(pPal);
	free(pPal);

	if (m_hPalette) {
      ::SelectPalette(dc->m_hDC, m_hPalette, FALSE);
      ::RealizePalette(dc->m_hDC);
	}
}

void COpenGLView::SetCurrent()
{
   ::wglMakeCurrent(m_dc->m_hDC, m_hGLRC);
};

void COpenGLView::FitRect(CRect &rc)
{
   // Make sure rectangle meets opengl standards
   rc.top = m_nHeight - rc.top;
   rc.bottom = m_nHeight - rc.bottom;
   rc.NormalizeRect();
};


//////////////////////////////////////////////////////////////////////
// COpenGLView render handlers

void COpenGLView::InitRender()
{
	ASSERT_VALID(m_dc);
   ::wglMakeCurrent(m_dc->m_hDC, m_hGLRC);
   // Turn off depth test for clear
   ::glDisable(GL_DEPTH_TEST);	
   // Clear the buffer
   ::glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   // Turn on depth test for clear
   ::glEnable(GL_DEPTH_TEST);	
   KfxCheckOpenGLForErrors();
};

void COpenGLView::DoneRender()
{
	ASSERT_VALID(m_dc);
   KfxCheckOpenGLForErrors();
   ::glFlush();
   ::SwapBuffers(m_dc->m_hDC);
   KfxCheckOpenGLForErrors();
};


/////////////////////////////////////////////////////////////////////////////
// COpenGLView message handlers

int COpenGLView::OnCreate(LPCREATESTRUCT lpCreateStruct, CDC *dc) 
{
	//if (CObject::OnCreate(lpCreateStruct) == -1)
	//	return -1;

   //m_dc = new CClientDC(this);
   m_dc = dc;
   if( m_dc==NULL ) {
      ::AfxMessageBox(IDS_ERR_DC);
   };

   SetupPixelFormat(m_dc);
	SetupPalette(m_dc);
   m_hGLRC = ::wglCreateContext(m_dc->m_hDC);
   if( m_hGLRC==NULL ) {
      ::AfxMessageBox(IDS_ERR_GLRC);
   };
   SetCurrent();
   SetDefaults(WIREFRAME);
  
	return 0;
}

void COpenGLView::OnSize(UINT nType, int cx, int cy) 
{
	//CObject::OnSize(nType, cx, cy);
	
   if( IsGLRCValid() ) {
      SetCurrent();
      glViewport(0,0,cx,cy);
   	glScissor(0,0,cx,cy);
      m_nWidth = cx;
      m_nHeight = cy;
   };
}

BOOL COpenGLView::OnEraseBkgnd(CDC* pDC) 
{
	//return CObject::OnEraseBkgnd(pDC);
   return TRUE;
}

void COpenGLView::OnDestroy() 
{
	//CObject::OnDestroy();
   Destroy();
}

void COpenGLView::OnInitialUpdate() 
{
   // Nothing here
}

void COpenGLView::OnSetFocus(CWnd* pOldWnd) 
{
   SetCurrent();
};

