// Model.h: interface for the CModel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MODEL_H__43020CCC_64CA_11D2_80BE_0080AD509054__INCLUDED_)
#define AFX_MODEL_H__43020CCC_64CA_11D2_80BE_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CModel : public CObject  
{
public:

#define MAX_TRIANGLES 4096
#define MAX_VERTS 2048
#define MAX_FRAMES 512
#define MAX_MD2SKINS 32
#define MAX_SKINNAME 64

   typedef struct
   {
	   int a, b, c;
	   int a_s, a_t, b_s, b_t, c_s, c_t;
   } make_index_list;

   typedef struct
   {
	   float x, y, z;
   } make_vertex_list;

   typedef struct
   {
	   make_vertex_list *vertex;
   } make_frame_list;

   typedef unsigned char byte;

   typedef struct
   {
	   float v[3];
   }vec3_t;

   typedef struct
   {
	   short s;
	   short t;
   } dstvert_t;

   typedef struct 
   {
	   short index_xyz[3];
	   short index_st[3];
   } dtriangle_t;


   typedef struct
   {
	   byte v[3];
	   byte lightnormalindex;
   } dtrivertx_t;

   typedef struct
   {
	   float scale[3];
	   float translate[3];
	   char name[16];
	   dtrivertx_t verts[1];

   } daliasframe_t;

   typedef struct
   {
	   int ident;
	   int version;

	   int skinwidth;
	   int skinheight;
	   int framesize;

	   int num_skins;
	   int num_xyz;
	   int num_st;
	   int num_tris;
	   int num_glcmds;
	   int num_frames;

	   int ofs_skins;
	   int ofs_st;
	   int ofs_tris;
	   int ofs_frames;
	   int ofs_glcmds; 
	   int ofs_end;

   } dmdl_t;

   typedef struct
   {
           vec3_t v;
           int		lightnormalindex;
   } trivert_t;

   typedef struct
   {
           vec3_t          mins, maxs;
           char            name[16];
           trivert_t       v[MAX_VERTS];
   } frame_t;


// Operations
public:
   BOOL Destroy();
	BOOL Load( LPCTSTR Filename );
	CModel();
	virtual ~CModel();

// Attributes
public:
	make_index_list *m_index_list;
	make_frame_list *m_frame_list;
protected:
	long m_iFrames;
   long m_iVertices;
   long m_iTriangles;

// Implementation
public:
   inline long NumberOfFrames() { return m_iFrames; };
   inline long NumberOfVertices() { return m_iVertices; };
   inline long NumberOfTriangles() { return m_iTriangles; };
};

#endif // !defined(AFX_MODEL_H__43020CCC_64CA_11D2_80BE_0080AD509054__INCLUDED_)
