// MainFrm.cpp : implementation of the CMainFrm class
//

#include "stdafx.h"
#include "CharAnim.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrm

IMPLEMENT_DYNAMIC(CMainFrm, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrm, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrm)
	ON_WM_CREATE()
	ON_CBN_SELCHANGE(IDC_VIEW, OnSelChangeView)
	ON_COMMAND(ID_TOOLS_OPTIONS, OnToolsOptions)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrm construction/destruction

CMainFrm::CMainFrm()
{
}

CMainFrm::~CMainFrm()
{
}

int CMainFrm::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	int i;
	if (!m_wndFileToolBar.CreateEx(this) ||
		!m_wndFileToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	if (!m_wndModeToolBar.CreateEx(this) ||
		!m_wndModeToolBar.LoadToolBar(ID_TOOLBAR_MODE))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	for( i=0; i<m_wndModeToolBar.GetCount(); i++ )
		if( (m_wndModeToolBar.GetButtonStyle(i) & TBBS_SEPARATOR)==0 )
           m_wndModeToolBar.SetButtonStyle( i, TBBS_CHECKBOX|TBBS_GROUP );

   if (!m_wndDlgBar.Create(this, IDR_MAINFRAME, 
		CBRS_ALIGN_TOP, AFX_IDW_DIALOGBAR))
	{
		TRACE0("Failed to create dialogbar\n");
		return -1;		// fail to create
	}
   CComboBox *cbo;
   cbo = (CComboBox *)m_wndDlgBar.GetDlgItem(IDC_VIEW);
   ASSERT(cbo);
   cbo->SetCurSel(0);

	if (!m_wndReBar.Create(this) ||
		 !m_wndReBar.AddBar(&m_wndFileToolBar) ||
		 !m_wndReBar.AddBar(&m_wndModeToolBar) ||
		 !m_wndReBar.AddBar(&m_wndDlgBar))
	{
		TRACE0("Failed to create rebar\n");
		return -1;      // fail to create
	};

	if (!m_wndStatusBar.Create(this) ||
       !m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndFileToolBar.SetBarStyle(m_wndFileToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);
	m_wndModeToolBar.SetBarStyle(m_wndModeToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);

	return 0;
}

BOOL CMainFrm::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.style = WS_OVERLAPPED | WS_CAPTION //| FWS_ADDTOTITLE
		| WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_MAXIMIZE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrm diagnostics

#ifdef _DEBUG
void CMainFrm::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrm::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CMainFrm Implementation

CEditorView *CMainFrm::GetActiveEditor()
{
   // Get the active MDI child window
   CMDIChildWnd *pChild = (CMDIChildWnd *)GetActiveFrame();
   if( pChild==NULL ) return NULL;
   // Get the active View
   CView *pView = pChild->GetActiveView();
   if( pView==NULL ) return NULL;
   // Make sure it is an EditorView
   if( pView->IsKindOf(RUNTIME_CLASS(CEditorView))==FALSE) return NULL;
   return (CEditorView *)pView;
};


/////////////////////////////////////////////////////////////////////////////
// CMainFrm message handlers

void CMainFrm::OnSelChangeView()
{
	CComboBox* pCBox = (CComboBox*)m_wndDlgBar.GetDlgItem(IDC_VIEW);
	ASSERT(pCBox);
   int nIndex = pCBox->GetCurSel();
	if (nIndex == CB_ERR)
		return;
   CEditorView *pView = GetActiveEditor();
   if( pView==NULL ) return;
   pView->m_cfg.CurrentView = (VIEWTYPE)nIndex;
   pView->UpdateViewData();
   pView->Render();
}


void CMainFrm::OnToolsOptions() 
{
   COptionsDlg dlg;
   dlg.DoModal();
}

void CMainFrm::SetStatusText(LPCTSTR szText)
{
   ASSERT(AfxIsValidString(szText));
   ASSERT_VALID(&m_wndStatusBar);
   m_wndStatusBar.SetPaneText(0,szText,TRUE);
}
