// EditorView.h : interface of the CEditorView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_EDITORVIEW_H__43020CA5_64CA_11D2_80BE_0080AD509054__INCLUDED_)
#define AFX_EDITORVIEW_H__43020CA5_64CA_11D2_80BE_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CCharAnimDoc;


class CEditorView : public CView
{
protected: // create from serialization only
	CEditorView();
	DECLARE_DYNCREATE(CEditorView)

// Types
public:

// Attributes
public:
	CCharAnimDoc* GetDocument();
   COpenGLView m_ogl;
   TRenderDef  m_cfg;
protected:
   TOOLMODE    m_action;
   BOOL        m_bCaptured;
   time_t      m_LastRenderTime;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditorView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	void SetViewDir(VIEWDIR NewDirection);
	BOOL Render();
	//
   void ChangeRenderMode(RENDERMODE RenderMode);
   void SetupPalette(CDC *dc);
   void SetupPixelFormat(CDC *dc);
   void RedoPalette();
   BOOL UpdateViewMatrix( TOOLMODE action, TRenderDef &cfg );
   void UpdateViewData();
   BOOL DoSelect(SELECTMODE mode, CRect *rc=NULL );
   void Resize(int x, int y);
   void DrawBox(CPoint &p1, CPoint &p2);
   //
   void OnBonesProperties();
   //
   inline time_t GetLastRenderTime() const { return m_LastRenderTime; };

	//
   virtual ~CEditorView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	void BuildCameraMatrix();
	void SetMessageText(LPCTSTR szText);
	//{{AFX_MSG(CEditorView)
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnModeMove();
	afx_msg void OnModeRotate();
	afx_msg void OnModeSelect();
	afx_msg void OnModeSize();
	afx_msg void OnViewWireframe();
	afx_msg void OnViewWirefront();
	afx_msg void OnViewTexture();
	afx_msg void OnViewShade();
	afx_msg void OnModeDefault();
	afx_msg void OnDirX();
	afx_msg void OnDirY();
	afx_msg void OnDirZ();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnUpdateViewWireframe(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewWirefront(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewTexture(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewShade(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnUpdateDirX(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDirY(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDirZ(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModeDefault(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModeMove(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModeRotate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModeSelect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModeSize(CCmdUI* pCmdUI);
	afx_msg void OnEditSelectall();
	afx_msg void OnEditRemoveall();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnViewBottom();
	afx_msg void OnViewRight();
	afx_msg void OnViewTop();
	afx_msg void OnViewLeft();
	afx_msg void OnUpdateModelDelete(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBoneShowvertices(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBonesAssign(CCmdUI* pCmdUI);
	afx_msg void OnUpdateModelProperties(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnBonesAssign();
	afx_msg void OnBoneShowvertices();
	afx_msg void OnUpdateDirXy(CCmdUI* pCmdUI);
	afx_msg void OnDirXy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in EditorView.cpp
inline CCharAnimDoc* CEditorView::GetDocument()
   { return (CCharAnimDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDITORVIEW_H__43020CA5_64CA_11D2_80BE_0080AD509054__INCLUDED_)
