// CharAnimDoc.cpp : implementation of the CCharAnimDoc class
//

#include "stdafx.h"
#include "CharAnim.h"

#include "CharAnimDoc.h"

#include "animobject.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCharAnimDoc

IMPLEMENT_DYNCREATE(CCharAnimDoc, CDocument)

BEGIN_MESSAGE_MAP(CCharAnimDoc, CDocument)
	//{{AFX_MSG_MAP(CCharAnimDoc)
	ON_COMMAND(ID_MODEL_ADDMODEL, OnAddmodel)
	ON_COMMAND(ID_MODEL_ADDFIGURE, OnAddFigure)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CCharAnimDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CCharAnimDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_ICharAnim to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {43020C97-64CA-11D2-80BE-0080AD509054}
static const IID IID_ICharAnim =
{ 0x43020c97, 0x64ca, 0x11d2, { 0x80, 0xbe, 0x0, 0x80, 0xad, 0x50, 0x90, 0x54 } };

BEGIN_INTERFACE_MAP(CCharAnimDoc, CDocument)
	INTERFACE_PART(CCharAnimDoc, IID_ICharAnim, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCharAnimDoc construction/destruction

CCharAnimDoc::CCharAnimDoc()
{
	m_iCurFrame = 0;
   m_iNumSelections = 0;

	EnableAutomation();
	AfxOleLockApp();
}

CCharAnimDoc::~CCharAnimDoc()
{
   // Nuke all mesh objects
   POSITION pos;
   pos = m_objects.GetHeadPosition();
   while( pos!=NULL ) {
      CObject *obj = m_objects.GetNext(pos);
      delete obj;
   };
   // Nuke all frames
   pos = m_frames.GetHeadPosition();
   while( pos!=NULL ) {
      CObject *obj = m_frames.GetNext(pos);
      delete obj;
   };
	// Done with OLE
   AfxOleUnlockApp();
}


/////////////////////////////////////////////////////////////////////////////
// CCharAnimDoc serialization

void CCharAnimDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCharAnimDoc diagnostics

#ifdef _DEBUG
void CCharAnimDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CCharAnimDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CCharAnimDoc commands

void CCharAnimDoc::SyncViews() 
{
   CEditorView *pCurrent = GetActiveEditorView();
   if( pCurrent==NULL ) return;
   // Traverse all positions and find other views to update
   POSITION pos = GetFirstViewPosition();   
   while (pos != NULL)   {
      CView *pView = GetNextView(pos);      
      if( pView!=pCurrent ) {
         if( pView->IsKindOf(RUNTIME_CLASS(CEditorView)) ) {
            CEditorView *pEditorView = (CEditorView *)pView;
            if( pEditorView->GetLastRenderTime() < pCurrent->GetLastRenderTime() ) {
               HGLRC hglrc = ::wglGetCurrentContext();
               HDC hdc = ::wglGetCurrentDC();
               pEditorView->m_ogl.SetCurrent();
               pEditorView->Render();
               ::wglMakeCurrent( hdc, hglrc );
            };
         };
      };
   };
};


CEditorView * CCharAnimDoc::GetActiveEditorView()
{
   CView *pView;
   // Get the active MDI MainFrame
   CMDIFrameWnd *pFrame = (CMDIFrameWnd *)AfxGetMainWnd();
   if(pFrame==NULL) return NULL;
   // Get the active MDI child window
   CMDIChildWnd *pChild = (CMDIChildWnd *)pFrame->GetActiveFrame();
   if( pChild==NULL ) return NULL;
   // Get the active View
   pView = pChild->GetActiveView();
   if( pView==NULL ) return NULL;
   // Make sure it is an EditorView
   if( pView->IsKindOf(RUNTIME_CLASS(CEditorView))==FALSE) return NULL;
   return (CEditorView *)pView;
}

void CCharAnimDoc::NumSelectedObjects()
{
   int cnt = 0;
   // Parse all object and render
   POSITION pos = m_objects.GetHeadPosition();
   for( int i=0; i<m_objects.GetCount(); i++ ) {
      CAnimObject *obj = (CAnimObject *)m_objects.GetNext(pos);
      ASSERT_VALID(obj);
      if( obj->IsSelected() ) cnt++;
   };
   m_iNumSelections = cnt;
   CEditorView *pView = GetActiveEditorView();
   if( pView==NULL ) return;
   pView->m_cfg.NumSelections = cnt;
}

CAnimFigure * CCharAnimDoc::GetSelectedFigure()
{
   POSITION pos = m_objects.GetHeadPosition();
   for( int i=0; i<m_objects.GetCount(); i++ ) {
      CAnimObject *obj = (CAnimObject *)m_objects.GetNext(pos);
      ASSERT_VALID(obj);
      if( obj->m_type==FIGURE )
         if( obj->IsSelected() ) return (CAnimFigure *)obj;
   };
   return NULL;
}



/////////////////////////////////////////////////////////////////////////////
// CCharAnimDoc message handlers

BOOL CCharAnimDoc::OnNewDocument()
{
	CApp *app = (CApp *)AfxGetApp();
   ASSERT_VALID(app);
   //app->CloseAllDocuments(FALSE);
   
   if (!CDocument::OnNewDocument())
		return FALSE;

	// Start with one frame
   CFrame *frm = (CFrame *)new CFrame;
   m_frames.AddHead(frm);
   // The add the camera
   /*CAnimCamera *obj = (CAnimCamera *)new CAnimCamera;
   if( obj==NULL ) return FALSE; // error: out of memory
   m_objects.AddTail(obj);*/

	return TRUE;
}

void CCharAnimDoc::OnAddmodel() 
{
   TCHAR szDefExt1[] = _T("ani");
   TCHAR szFilter1[] = _T("Quake2 models (*.md2)|*.md2|All Files (*.*)|*.*||");
   TCHAR szDefExt2[] = _T("pcx");
   TCHAR szFilter2[] = _T("PCX Image (*.pcx)|*.pcx|All Files (*.*)|*.*||");
   CWaitCursor wait;
   CFileDialog model_dlg(TRUE, szDefExt1, NULL, OFN_HIDEREADONLY, szFilter1 );
   model_dlg.DoModal();
   wait.Restore();
   CString sFilename = model_dlg.GetPathName();
   if( sFilename.IsEmpty() ) return;

   CAnimModel *obj = (CAnimModel *)new CAnimModel;
   if( obj==NULL ) return; // error: out of memory
   if( obj->LoadModel(sFilename)==FALSE) {
      AfxMessageBox(IDS_ERR_BADMODEL);
      return;
   };
   m_objects.AddTail(obj);

   CFileDialog texture_dlg(TRUE, szDefExt2, NULL, OFN_HIDEREADONLY, szFilter2 );
   texture_dlg.DoModal();
   wait.Restore();
   sFilename = texture_dlg.GetPathName();
   if( sFilename.IsEmpty() ) return;
   obj->LoadTexturePCX(sFilename);

   UpdateAllViews(NULL);
   SetModifiedFlag();
}

void CCharAnimDoc::OnAddFigure() 
{
   CWaitCursor wait;
   TCHAR szDefExt1[] = _T("ani");
   TCHAR szFilter1[] = _T("Quake2 models (*.md2)|*.md2|All Files (*.*)|*.*||");
   TCHAR szDefExt2[] = _T("pcx");
   TCHAR szFilter2[] = _T("PCX Image (*.pcx)|*.pcx|All Files (*.*)|*.*||");
   TCHAR szDefExt3[] = _T("bon");
   TCHAR szFilter3[] = _T("Bones (*.bon)|*.bon|All Files (*.*)|*.*||");
   CFileDialog model_dlg(TRUE, szDefExt1, NULL, OFN_HIDEREADONLY, szFilter1 );
   model_dlg.DoModal();
   wait.Restore();
   CString sFilename = model_dlg.GetPathName();
   if( sFilename.IsEmpty() ) return;

   CAnimFigure *obj = (CAnimFigure *)new CAnimFigure;
   if( obj==NULL ) return; // error: out of memory
   if( obj->LoadModel(sFilename)==FALSE) {
      AfxMessageBox(IDS_ERR_BADMODEL);
      return;
   };
   m_objects.AddTail(obj);

   CFileDialog bones_dlg(TRUE, szDefExt3, NULL, OFN_HIDEREADONLY, szFilter3 );
   bones_dlg.DoModal();
   wait.Restore();
   sFilename = bones_dlg.GetPathName();
   if( sFilename.IsEmpty() ) return;
   obj->m_bones.LoadBones( sFilename, obj->NumberOfVertices() );

   CFileDialog texture_dlg(TRUE, szDefExt2, NULL, OFN_HIDEREADONLY, szFilter2 );
   texture_dlg.DoModal();
   wait.Restore();
   sFilename = texture_dlg.GetPathName();
   if( sFilename.IsEmpty() ) return;
   obj->LoadTexturePCX(sFilename);

   UpdateAllViews(NULL);    
   SetModifiedFlag();
}

BOOL CCharAnimDoc::OnIdle(long lCount) 
// This Idle function is called from the CWinApp object
// and allows the document to update various things
// One important issue, is to update all views with the
// latest changes to the models...
{
   switch( lCount ) {
   case 0:
   case 1:
   case 2:
   case 3:
   case 4:
      // Nothing right now...
      return TRUE;
   case 5:
      NumSelectedObjects();
      return TRUE;
   case 6:
      // Sync view (if changes has happend)
      // This task is only executed when we have been
      // idle for some time...
      SyncViews();
      return TRUE;
   default:
      return FALSE; // no more idle events
   };
};

