// AnimObject.h: interface for the CAnimObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANIMOBJECT_H__43020CCE_64CA_11D2_80BE_0080AD509054__INCLUDED_)
#define AFX_ANIMOBJECT_H__43020CCE_64CA_11D2_80BE_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "editorview.h"

typedef enum {
   MODEL,
   FIGURE,
   CAMERA,
   LIGHT,
} MODELTYPE;

class CAnimObject : public CObject  
{
public:
	CAnimObject();
	virtual ~CAnimObject();

// Types
public:

// Attributes
public:
   MODELTYPE m_type;
   GLfloat m_trans[3];
   GLfloat m_rot[3];
   //
   float   m_colorR, m_colorG, m_colorB;
   //
   BOOL    m_bSelected;
   tCoord *m_CoordArray;
   tCoord *m_CoordUndoArray;
   BOOL   *m_SelectArray;

// Operations
public:
   virtual BOOL Render( TRenderDef &cfg ) { ASSERT(FALSE); return FALSE; };
   virtual BOOL UpdateMatrix( TOOLMODE action, TRenderDef &cfg );
   virtual BOOL UpdateVertexMatrix(TOOLMODE action, TRenderDef &cfg );
   virtual BOOL Select( CDC *dc, SELECTMODE mode, TRenderDef &cfg, CRect &rc );
   virtual BOOL GetFrame(TRenderDef &cfg) { ASSERT(FALSE); return FALSE; };
   virtual BOOL SetFrame() { ASSERT(FALSE); return FALSE; };
   virtual BOOL SaveClipboard(TRenderDef &cfg) { ASSERT(FALSE); return FALSE; };
   virtual BOOL RestoreClipboard(TRenderDef &cfg) { ASSERT(FALSE); return FALSE; };
   //
   virtual BOOL IsSelected() const { return m_bSelected; };
   virtual void SetSelected(BOOL state) { m_bSelected = state; };
   //
   virtual long NumberOfFrames() { ASSERT(FALSE); return FALSE; };
   virtual long NumberOfVertices() { ASSERT(FALSE); return FALSE; };
   virtual long NumberOfTriangles() { ASSERT(FALSE); return FALSE; };
   //
   virtual long GetNearestVertex( CDC *dc, TRenderDef &cfg, CPoint &p, long *index=NULL );

// Implementation
public:

};

#endif // !defined(AFX_ANIMOBJECT_H__43020CCE_64CA_11D2_80BE_0080AD509054__INCLUDED_)
