// AnimObject.cpp: implementation of the CAnimObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharAnim.h"
#include "AnimObject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAnimObject::CAnimObject()
{
   m_rot[0] = m_rot[1] = m_rot[2] =
   m_trans[0] = m_trans[1] = m_trans[2] = 0.0f;
   m_CoordArray = NULL;
   m_CoordUndoArray = NULL;
   m_SelectArray = NULL;
   m_bSelected = FALSE;
   m_colorR = 0.0f; m_colorG = 1.0f; m_colorB = 0.0f;
}

CAnimObject::~CAnimObject()
{
   if( m_CoordArray!=NULL ) delete [] m_CoordArray;
   if( m_CoordUndoArray!=NULL ) delete [] m_CoordUndoArray;
   if( m_SelectArray!=NULL ) delete [] m_SelectArray;
}

//////////////////////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////////////////////

BOOL CAnimObject::UpdateMatrix(TOOLMODE action, TRenderDef &cfg )
{
	int dx = cfg.OrgPoint.x - cfg.CurPoint.x;
	int dy = cfg.OrgPoint.y - cfg.CurPoint.y;

	switch(action) {
	case TOOL_MOVE:
		//m_trans[0] -= dx / 5.0f;
		//m_trans[1] += dy / 5.0f;
      VectorMA(m_trans, -dx / 5.0f, cfg.camera.forward, m_trans);
      VectorMA(m_trans, -dy / 5.0f, cfg.camera.right, m_trans);
      //VectorMA(m_trans, -dx / 5.0f, cfg.camera.vright, m_trans);
      //m_trans[2] -= dy / 5.0f;
		break;
	case TOOL_ROTATE:
      {
      int a1,a2;
      switch(cfg.Direction) {
      case DIR_X:
         a1=0; a2=1;
         break;
      case DIR_Y:
         a1=1; a2=2;
         break;
      case DIR_Z:
         a1=0; a2=2;
         break;
      default:
         ASSERT(FALSE);
      };
      m_rot[a1] += (dy * 180.0f) / 500.0f;
		m_rot[a2] -= (dx * 180.0f) / 500.0f;
		#define clamp(x) x = x > 360.0f ? x-360.0f : x < -360.0f ? x+=360.0f : x
		clamp(m_rot[a1]);
		clamp(m_rot[a2]);
		break;
      }
	case TOOL_ZOOM:
		m_trans[2] -= (dx+dy) / 4.0f;
		break;
	}
   return TRUE;
};

BOOL CAnimObject::Select( CDC *dc, SELECTMODE mode, TRenderDef &cfg, CRect &rc )
{
   // First process a few of the easy selection actions
   // These include ADD_ALL and REMOVE_ALL selections
   int i;
   switch( cfg.CurrentView ) {
   case VIEW_OBJECT:
      switch( mode ) {
      case SEL_ADD_ALL:
         SetSelected(TRUE);
         return TRUE;
      case SEL_REMOVE_ALL:
         SetSelected(FALSE);
         return TRUE;
      };
      break;
   case VIEW_VERTEX:
      switch( mode ) {
      case SEL_ADD_ALL:
         SetSelected(TRUE);
         for( i=0; i<NumberOfVertices(); i++ )
            m_SelectArray[i] = TRUE;
         return TRUE;
      case SEL_REMOVE_ALL:
         SetSelected(FALSE);
         for( i=0; i<NumberOfVertices(); i++ )
            m_SelectArray[i] = FALSE;
         return TRUE;
      };
      break;
   default:
      // Unsupported viewing mode
      return FALSE;
   }
   
   // Now do the tricky one...
   // (this is the partial selection within a rectangle)
   VIEWTYPE oldview = cfg.CurrentView;
   cfg.CurrentView = VIEW_SELECT;
   
   long cnt = NumberOfVertices();
   GLfloat *OutputBuffer = OutputBuffer = new GLfloat[ cnt*6 ];
   if( OutputBuffer==NULL ) return FALSE; // error: out of memory
   
   KfxRemoveOpenGLErrors();
   
   glFeedbackBuffer(cnt*6, GL_3D, OutputBuffer);
   glRenderMode(GL_FEEDBACK);
   glPushMatrix();

   Render(cfg);
   glPopMatrix();

   GLint count = glRenderMode(GL_RENDER); 
   GLint size = count;
   if (count > 0) {
      //
	   GLfloat token,point[3];
	   int pos;
	   while (count) {
		   token = OutputBuffer[size - count]; // Get next token
		   count--;
		   if (token == GL_PASS_THROUGH_TOKEN)	// Marker
		   {
			   pos = (int)OutputBuffer[size - count]; // What VERTEX?
			   count--;
		   }
		   else if (token == GL_POINT_TOKEN) {
			   // Get components of vertex
			   for (int loop = 0; loop < 3; loop++)
			   {
				   point[loop] = OutputBuffer[size - count];
				   count--;
			   }
			   // Make sure that the vertex is inside the
            // select rectangle
			   if (((int)point[0] >= rc.left) && 
				    ((int)point[0] <= rc.right) && 
				    ((int)point[1] >= rc.top) && 
				    ((int)point[1] <= rc.bottom) )
               switch( oldview ) {
               case VIEW_OBJECT:
                  SetSelected(mode==SEL_ADD);
                  break;
               case VIEW_VERTEX:
                  m_SelectArray[pos] = (mode==SEL_ADD);
                  SetSelected(mode==SEL_ADD);
                  break;
               };
		   }
	   }     
   }
   KfxCheckOpenGLForErrors();

   cfg.CurrentView = oldview;
   delete [] OutputBuffer;
   return TRUE;
};

long CAnimObject::GetNearestVertex( CDC *dc, TRenderDef &cfg, CPoint &p, long *index/*=NULL*/ )
{
   // Now do the tricky one...
   // (this is the partial selection within a rectangle)
   VIEWTYPE oldview = cfg.CurrentView;
   cfg.CurrentView = VIEW_SELECT;
   unsigned long nearest = 0xFFFFFFFF;
   int coord = -1;
   
   long cnt = NumberOfVertices();
   if( cnt==0 ) return -1;
   GLfloat *OutputBuffer = OutputBuffer = new GLfloat[ cnt*6 ];
   if( OutputBuffer==NULL ) return -1; // error: out of memory
   
   KfxRemoveOpenGLErrors();
   
   glFeedbackBuffer(cnt*6, GL_3D, OutputBuffer);
   glRenderMode(GL_FEEDBACK);
   glPushMatrix();

   Render(cfg);
   glPopMatrix();

   GLint count = glRenderMode(GL_RENDER); 
   GLint size = count;
   if (count > 0) {
      //
	   GLfloat token, point[3];
	   int pos;
	   while (count) {
		   token = OutputBuffer[size - count]; // Get next token
		   count--;
		   if (token == GL_PASS_THROUGH_TOKEN)	// Marker
		   {
			   pos = (int)OutputBuffer[size - count]; // What vertex?
			   count--;
		   }
		   else if (token == GL_POINT_TOKEN) {
			   // Get components of vertex
			   for (int loop = 0; loop < 3; loop++) {
				   point[loop] = OutputBuffer[size - count];
				   count--;
			   }
            // Calculate distance from point
			   unsigned long r = ( ((long)point[0]-p.x)*((long)point[0]-p.x) ) +
                              ( ((long)point[1]-p.y)*((long)point[1]-p.y) );
            if( r<nearest ) {
               nearest = r;
               coord = pos;
            };
		   }
	   }     
   }
   KfxCheckOpenGLForErrors();

   // Clean up
   cfg.CurrentView = oldview;
   delete [] OutputBuffer;
   // Return values
   if( index!=NULL ) *index = coord;
   return nearest;
};

BOOL CAnimObject::UpdateVertexMatrix(TOOLMODE action, TRenderDef &cfg )
{
   int frame = 1;
   for( int i=0; i<NumberOfVertices(); i++ ) {
      // Point is selected?
      if( m_SelectArray[i] ) {
         switch( action ) {
         case TOOL_MOVE:
            GLfloat coord[3];
            GLfloat delta[3];
            coord[0] = (cfg.CurPoint.x - cfg.OrgPoint.x)/5.0f;
            coord[1] = 0.0f;
            coord[2] = (cfg.CurPoint.y - cfg.OrgPoint.y)/-5.0f;
            KfxRotateCoord( coord, cfg.rot, delta );
            m_CoordArray[i].x = m_CoordArray[i].x + delta[0];
            m_CoordArray[i].y = m_CoordArray[i].y + delta[1];
            m_CoordArray[i].z = m_CoordArray[i].z + delta[2];
            break;
         case TOOL_ROTATE:
            break;
         case TOOL_SIZE:
            break;
         };
      };
   };
   return TRUE;
};
