// AnimModel.h: interface for the CAnimModel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANIMMODEL_H__43020CD1_64CA_11D2_80BE_0080AD509054__INCLUDED_)
#define AFX_ANIMMODEL_H__43020CD1_64CA_11D2_80BE_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AnimObject.h"

class CAnimModel : public CAnimObject  
{
public:
	CAnimModel();
	virtual ~CAnimModel();

// Attributes
public:
   CModel m_model;
   CString m_sModelFilename;
   CString m_sTextureFilename;
   int m_iWidth, m_iHeight;
   int m_iScaledWidth, m_iScaledHeight;
   GLubyte *m_glTexture;

// Implementation
public:
   virtual BOOL Render( TRenderDef &cfg );
   virtual BOOL UpdateMatrix( TOOLMODE action, TRenderDef &cfg );
   //
   virtual BOOL GetFrame(TRenderDef &cfg);
   virtual BOOL SetFrame();
   //
   virtual long NumberOfFrames() { return m_model.NumberOfFrames(); };
   virtual long NumberOfVertices() { return m_model.NumberOfVertices(); };
   virtual long NumberOfTriangles() { return m_model.NumberOfTriangles(); };

// Operations
public:
   BOOL LoadModel( LPCTSTR szFilename );
	BOOL LoadTexturePCX( LPCTSTR szFilename );
};

#endif // !defined(AFX_ANIMMODEL_H__43020CD1_64CA_11D2_80BE_0080AD509054__INCLUDED_)
